/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCode;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnreachableCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreachableCode.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1755#2,3:62\n*S KotlinDebug\n*F\n+ 1 UnreachableCode.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCode\n*L\n49#1:62,3\n*E\n"})
public final class UnreachableCode
extends Rule {
    @NotNull
    private final Issue issue;

    public UnreachableCode(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnreachableCode", Severity.Warning, "Unreachable code detected. This code should be removed.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ UnreachableCode(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitExpression(@NotNull KtExpression expression) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitExpression(expression);
            Iterable $this$any$iv = this.getBindingContext().getDiagnostics().forElement((PsiElement)expression);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNREACHABLE_CODE) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.USELESS_ELVIS))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This expression is unreachable code which should either be used or removed.", null, null, 24, null));
        }
    }

    public UnreachableCode() {
        this(null, 1, null);
    }
}

