/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnsafeCast;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryWithTypeRHSExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnsafeCast.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeCast.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnsafeCast\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1755#2,3:64\n*S KotlinDebug\n*F\n+ 1 UnsafeCast.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnsafeCast\n*L\n49#1:64,3\n*E\n"})
public final class UnsafeCast
extends Rule {
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;

    public UnsafeCast(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"UNCHECKED_CAST");
        this.issue = new Issue("UnsafeCast", Severity.Defect, "Cast operator throws an exception if the cast is not possible.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ UnsafeCast(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Diagnostics diagnostics = this.getBindingContext().getDiagnostics();
            KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
            Iterable $this$any$iv = diagnostics.forElement((PsiElement)ktSimpleNameExpression);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.CAST_NEVER_SUCCEEDS)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            Issue issue = this.getIssue();
            Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append(expression.getLeft().getText()).append(" cast to ");
            KtTypeReference ktTypeReference = expression.getRight();
            String string = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (string == null) {
                string = "";
            }
            this.report((Finding)new CodeSmell(issue, entity, stringBuilder.append(string).append(" cannot succeed.").toString(), null, null, 24, null));
        }
        super.visitBinaryWithTypeRHSExpression(expression);
    }

    public UnsafeCast() {
        this(null, 1, null);
    }
}

