/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException$parameterReferences$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\f*\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "ignoredExceptionTypes", "", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isExceptionSwallowed", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "isExceptionSwallowedOrUnused", "isExceptionUnused", "visitCatchSection", "", "findReferenceInVariable", "Lorg/jetbrains/kotlin/psi/KtExpression;", "referenceName", "variableName", "catchBody", "parameterReferences", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "parameterName", "Companion", "detekt-rules-exceptions"})
public final class SwallowedException
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final List<String> ignoredExceptionTypes;
    private final LazyRegex allowedExceptionNameRegex$delegate;
    @NotNull
    public static final String IGNORED_EXCEPTION_TYPES = "ignoredExceptionTypes";
    @NotNull
    public static final String ALLOWED_EXCEPTION_NAME_REGEX = "allowedExceptionNameRegex";
    @NotNull
    private static final List<String> defaultIgnoredExceptions;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(SwallowedException.class, ALLOWED_EXCEPTION_NAME_REGEX, "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0))};
        Companion = new Companion(null);
        defaultIgnoredExceptions = CollectionsKt.listOf((Object[])new String[]{"NumberFormatException", "InterruptedException", "ParseException", "MalformedURLException"});
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getAllowedExceptionNameRegex() {
        return this.allowedExceptionNameRegex$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            KtParameter ktParameter = catchClause.getCatchParameter();
            String exceptionType = ktParameter != null && (ktParameter = ktParameter.getTypeReference()) != null ? ktParameter.getText() : null;
            Iterable $this$any$iv = this.ignoredExceptionTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = exceptionType;
                    if (!(string != null && StringsKt.contains((CharSequence)string, (CharSequence)it, (boolean)true))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl && this.isExceptionSwallowedOrUnused(catchClause) && !AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchClause), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isExceptionSwallowedOrUnused(KtCatchClause catchClause) {
        return this.isExceptionUnused(catchClause) || this.isExceptionSwallowed(catchClause);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionUnused(KtCatchClause catchClause) {
        void $this$anyDescendantOfType$iv;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"catchClause.catchBody ?: return true");
        KtExpression catchBody = ktExpression;
        PsiElement psiElement = (PsiElement)catchBody;
        Function1 predicate$iv = (Function1)new Function1<KtNameReferenceExpression, Boolean>(this, parameterName){
            final /* synthetic */ SwallowedException this$0;
            final /* synthetic */ String $parameterName;

            public final boolean invoke(@NotNull KtNameReferenceExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SwallowedException.access$getIgnoredExceptionTypes$p(this.this$0).contains(it.getText()) || Intrinsics.areEqual((Object)it.getText(), (Object)this.$parameterName);
            }
            {
                this.this$0 = swallowedException;
                this.$parameterName = string;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExceptionSwallowed(KtCatchClause catchClause) {
        void $this$anyDescendantOfType$iv;
        KtExpression catchBody;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchBody = catchClause.getCatchBody();
        if (ktExpression == null) return false;
        PsiElement psiElement = (PsiElement)ktExpression;
        Function1 predicate$iv = (Function1)new Function1<KtThrowExpression, Boolean>(this, parameterName, catchBody){
            final /* synthetic */ SwallowedException this$0;
            final /* synthetic */ String $parameterName;
            final /* synthetic */ KtExpression $catchBody;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull KtThrowExpression throwExpr) {
                KtExpression it;
                Intrinsics.checkNotNullParameter((Object)throwExpr, (String)"throwExpr");
                List parameterReferences = SwallowedException.access$parameterReferences(this.this$0, throwExpr, this.$parameterName, this.$catchBody);
                Collection collection = parameterReferences;
                boolean bl = false;
                if (collection.isEmpty()) return false;
                boolean bl2 = true;
                if (!bl2) return false;
                Iterable $this$all$iv = parameterReferences;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator<T> iterator = $this$all$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    T element$iv = iterator.next();
                    it = (KtExpression)element$iv;
                    boolean bl3 = false;
                } while (it instanceof KtDotQualifiedExpression);
                return false;
            }
            {
                this.this$0 = swallowedException;
                this.$parameterName = string;
                this.$catchBody = ktExpression;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> parameterReferences(KtThrowExpression $this$parameterReferences, String parameterName, KtExpression catchBody) {
        List list;
        PsiElement psiElement;
        boolean bl = false;
        Map parameterReferencesInVariables = new LinkedHashMap();
        KtExpression ktExpression = $this$parameterReferences.getThrownExpression();
        if (ktExpression != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Iterable $this$collectDescendantsOfType_u24default$iv;
            psiElement = (PsiElement)ktExpression;
            Function1 predicate$iv = parameterReferences$$inlined$collectDescendantsOfType$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType22 = false;
            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType = false;
            void var10_13 = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var13_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            $this$collectDescendantsOfType_u24default$iv = (List)to$iv$iv$iv;
            boolean $i$f$mapNotNull = false;
            void $i$f$collectDescendantsOfType22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtExpression ktExpression2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                KtNameReferenceExpression reference2 = (KtNameReferenceExpression)element$iv$iv;
                boolean bl3 = false;
                String referenceText = reference2.getText();
                if (Intrinsics.areEqual((Object)referenceText, (Object)parameterName)) {
                    ktExpression2 = KtPsiUtilKt.getQualifiedExpressionForReceiverOrThis((KtExpression)((KtExpression)reference2));
                } else {
                    ktExpression2 = (KtExpression)parameterReferencesInVariables.get(referenceText);
                    if (ktExpression2 == null) {
                        KtExpression ktExpression3 = (KtExpression)reference2;
                        String string = referenceText;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referenceText");
                        if (this.findReferenceInVariable(ktExpression3, parameterName, string, catchBody) != null) {
                            KtExpression ktExpression4;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            KtExpression it = ktExpression4;
                            boolean bl6 = false;
                            parameterReferencesInVariables.put(referenceText, it);
                            ktExpression2 = ktExpression4;
                        } else {
                            ktExpression2 = null;
                        }
                    }
                }
                if (ktExpression2 == null) continue;
                KtExpression ktExpression5 = ktExpression2;
                boolean bl7 = false;
                boolean bl8 = false;
                KtExpression it$iv$iv = ktExpression5;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        psiElement = list;
        boolean bl10 = false;
        Object object = psiElement;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final KtExpression findReferenceInVariable(KtExpression $this$findReferenceInVariable, String referenceName, String variableName, KtExpression catchBody) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$findReferenceInVariable;
        boolean $i$f$getStrictParentOfType = false;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression block = ktBlockExpression;
        Function1<KtBlockExpression, KtExpression> $fun$find$1 = new Function1<KtBlockExpression, KtExpression>(variableName, referenceName, catchBody){
            final /* synthetic */ String $variableName;
            final /* synthetic */ String $referenceName;
            final /* synthetic */ KtExpression $catchBody;

            @Nullable
            public final KtExpression invoke(@NotNull KtBlockExpression block) {
                KtExpression ktExpression;
                Object object;
                boolean bl;
                KtProperty $this$findDescendantOfType$iv;
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                PsiElement psiElement = (PsiElement)block;
                Function1 predicate$iv2 = (Function1)new Function1<KtProperty, Boolean>(this){
                    final /* synthetic */ findReferenceInVariable.1 this$0;

                    public final boolean invoke(@NotNull KtProperty it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getName(), (Object)this.this$0.$variableName);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                boolean $i$f$findDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
                boolean $i$f$findDescendantOfType2 = false;
                Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv2, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (element instanceof KtProperty && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                            this.$result.element = element;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                    }
                });
                KtProperty ktProperty = (KtProperty)((PsiElement)result$iv$iv.element);
                if (ktProperty != null) {
                    $this$findDescendantOfType$iv = ktProperty;
                    boolean predicate$iv2 = false;
                    bl = false;
                    KtProperty property = $this$findDescendantOfType$iv;
                    boolean bl2 = false;
                    KtExpression initializer = property.getInitializer();
                    if (initializer instanceof KtDotQualifiedExpression) {
                        KtExpression ktExpression2 = initializer;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        KtDotQualifiedExpression it = (KtDotQualifiedExpression)ktExpression2;
                        boolean bl5 = false;
                        object = Intrinsics.areEqual((Object)it.getReceiverExpression().getText(), (Object)this.$referenceName) ? ktExpression2 : null;
                    } else {
                        KtExpression ktExpression3 = initializer;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        KtExpression it = ktExpression3;
                        boolean bl8 = false;
                        KtExpression ktExpression4 = it;
                        object = Intrinsics.areEqual((Object)(ktExpression4 != null ? ktExpression4.getText() : null), (Object)this.$referenceName) ? ktExpression3 : null;
                    }
                } else {
                    object = null;
                }
                KtExpression reference2 = object;
                if (reference2 != null) {
                    ktExpression = reference2;
                } else if (Intrinsics.areEqual((Object)block, (Object)this.$catchBody)) {
                    ktExpression = null;
                } else {
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)block;
                    boolean $i$f$getStrictParentOfType = false;
                    KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
                    if (ktBlockExpression != null) {
                        psiElement = ktBlockExpression;
                        boolean bl9 = false;
                        bl = false;
                        PsiElement it = psiElement;
                        boolean bl10 = false;
                        ktExpression = this.invoke((KtBlockExpression)it);
                    } else {
                        ktExpression = null;
                    }
                }
                return ktExpression;
            }
            {
                this.$variableName = string;
                this.$referenceName = string2;
                this.$catchBody = ktExpression;
                super(1);
            }
        };
        return $fun$find$1.invoke(block);
    }

    /*
     * WARNING - void declaration
     */
    public SwallowedException(@NotNull Config config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SwallowedException", Severity.CodeSmell, "The caught exception is swallowed. The original exception could be lost.", Debt.Companion.getTWENTY_MINS());
        Iterable iterable = PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)IGNORED_EXCEPTION_TYPES, defaultIgnoredExceptions);
        SwallowedException swallowedException = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*");
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        swallowedException.ignoredExceptionTypes = collection;
        this.allowedExceptionNameRegex$delegate = new LazyRegex(ALLOWED_EXCEPTION_NAME_REGEX, "_|(ignore|expected).*");
    }

    public /* synthetic */ SwallowedException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public SwallowedException() {
        this(null, 1, null);
    }

    public static final /* synthetic */ List access$getIgnoredExceptionTypes$p(SwallowedException $this) {
        return $this.ignoredExceptionTypes;
    }

    public static final /* synthetic */ List access$parameterReferences(SwallowedException $this, KtThrowExpression $this$access_u24parameterReferences, String parameterName, KtExpression catchBody) {
        return $this.parameterReferences($this$access_u24parameterReferences, parameterName, catchBody);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException$Companion;", "", "()V", "ALLOWED_EXCEPTION_NAME_REGEX", "", "IGNORED_EXCEPTION_TYPES", "defaultIgnoredExceptions", "", "getDefaultIgnoredExceptions$detekt_rules_exceptions", "()Ljava/util/List;", "detekt-rules-exceptions"})
    public static final class Companion {
        @NotNull
        public final List<String> getDefaultIgnoredExceptions$detekt_rules_exceptions() {
            return defaultIgnoredExceptions;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

