/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.TooGenericExceptionCaught;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/TooGenericExceptionCaught;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex$annotations", "()V", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "exceptionNames", "", "", "getExceptionNames$annotations", "getExceptionNames", "()Ljava/util/Set;", "exceptionNames$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isTooGenericException", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "Companion", "detekt-rules-exceptions"})
public final class TooGenericExceptionCaught
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty exceptionNames$delegate;
    @NotNull
    private final ReadOnlyProperty allowedExceptionNameRegex$delegate;
    @NotNull
    private static final List<String> caughtExceptionDefaults;

    public TooGenericExceptionCaught(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "The caught exception is too generic. Prefer catching specific exceptions to the case that is currently handled.", Debt.Companion.getTWENTY_MINS());
        this.exceptionNames$delegate = ConfigPropertyKt.config(caughtExceptionDefaults, (Function1)exceptionNames.2.INSTANCE);
        this.allowedExceptionNameRegex$delegate = ConfigPropertyKt.config((Object)"_|(ignore|expected).*", (Function1)allowedExceptionNameRegex.2.INSTANCE);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Set<String> getExceptionNames() {
        return (Set)this.exceptionNames$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="exceptions which are too generic and should not be caught")
    private static /* synthetic */ void getExceptionNames$annotations() {
    }

    private final Regex getAllowedExceptionNameRegex() {
        return (Regex)this.allowedExceptionNameRegex$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores too generic exception types which match this regex")
    private static /* synthetic */ void getAllowedExceptionNameRegex$annotations() {
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        KtParameter ktParameter = catchClause.getCatchParameter();
        if (ktParameter != null) {
            KtParameter catchParameter = ktParameter;
            boolean bl = false;
            if (this.isTooGenericException(catchParameter.getTypeReference()) && !AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchParameter), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
        super.visitCatchSection(catchClause);
    }

    private final boolean isTooGenericException(KtTypeReference typeReference) {
        KtTypeReference ktTypeReference = typeReference;
        return CollectionsKt.contains((Iterable)this.getExceptionNames(), (Object)(ktTypeReference != null ? ktTypeReference.getText() : null));
    }

    static {
        Object[] objectArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooGenericExceptionCaught.class, "exceptionNames", "getExceptionNames()Ljava/util/Set;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooGenericExceptionCaught.class, "allowedExceptionNameRegex", "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"ArrayIndexOutOfBoundsException", "Error", "Exception", "IllegalMonitorStateException", "IndexOutOfBoundsException", "NullPointerException", "RuntimeException", "Throwable"};
        caughtExceptionDefaults = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/TooGenericExceptionCaught$Companion;", "", "()V", "caughtExceptionDefaults", "", "", "getCaughtExceptionDefaults", "()Ljava/util/List;", "detekt-rules-exceptions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getCaughtExceptionDefaults() {
            return caughtExceptionDefaults;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

