/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ObjectExtendsThrowable;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitObjectDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "isSubtypeOfThrowable", "", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nObjectExtendsThrowable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectExtendsThrowable.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ObjectExtendsThrowable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1747#2,3:79\n*S KotlinDebug\n*F\n+ 1 ObjectExtendsThrowable.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ObjectExtendsThrowable\n*L\n75#1:79,3\n*E\n"})
public final class ObjectExtendsThrowable
extends Rule {
    @NotNull
    private final Issue issue;

    public ObjectExtendsThrowable(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ObjectExtendsThrowable", Severity.CodeSmell, "An `object` should not extend and type of Throwable. Throwables are stateful and should be instantiated only when needed for when a specific error occurs. An `object`, being a singleton, that extends any type of Throwable consequently introduces a global singleton exception whose instance may be inadvertently reused from multiple places, thus introducing shared mutable state.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ ObjectExtendsThrowable(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitObjectDeclaration(declaration);
        if (!declaration.isObjectLiteral() && this.isSubtypeOfThrowable(declaration)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), declaration.getNameAsSafeName() + " should be a class instead of an object because it is a subtype of Throwable.", null, null, 24, null));
        }
    }

    private final boolean isSubtypeOfThrowable(KtObjectDeclaration $this$isSubtypeOfThrowable) {
        boolean bl;
        block4: {
            SimpleType simpleType;
            ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)$this$isSubtypeOfThrowable);
            Collection collection = classDescriptor != null && (simpleType = classDescriptor.getDefaultType()) != null ? TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType)) : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!TypeUtilsKt.isNotNullThrowable((KotlinType)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public ObjectExtendsThrowable() {
        this(null, 1, null);
    }
}

