/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException$parameterReferences$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010 \u001a\u0004\u0018\u00010!*\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020!H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020!0\u000e*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020!H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex$annotations", "()V", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoredExceptionTypes", "", "", "getIgnoredExceptionTypes$annotations", "getIgnoredExceptionTypes", "()Ljava/util/List;", "ignoredExceptionTypes$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isExceptionSwallowed", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "isExceptionSwallowedOrUnused", "isExceptionUnused", "visitCatchSection", "", "findReferenceInVariable", "Lorg/jetbrains/kotlin/psi/KtExpression;", "referenceName", "variableName", "catchBody", "parameterReferences", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "parameterName", "Companion", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nSwallowedException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwallowedException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1747#2,3:180\n1603#2,9:223\n1855#2:232\n1856#2:234\n1612#2:235\n242#3:183\n253#3,9:184\n274#3:193\n242#3:194\n253#3,9:195\n274#3:204\n277#3,15:205\n228#3:220\n239#3:221\n296#3:222\n142#3:236\n253#3,9:237\n274#3:246\n142#3:248\n1#4:233\n1#4:247\n*S KotlinDebug\n*F\n+ 1 SwallowedException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException\n*L\n92#1:180,3\n129#1:223,9\n129#1:232\n129#1:234\n129#1:235\n108#1:183\n108#1:184,9\n108#1:193\n116#1:194\n116#1:195,9\n116#1:204\n128#1:205,15\n128#1:220\n128#1:221\n128#1:222\n148#1:236\n151#1:237,9\n151#1:246\n163#1:248\n129#1:233\n*E\n"})
public final class SwallowedException
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoredExceptionTypes$delegate;
    @NotNull
    private final ReadOnlyProperty allowedExceptionNameRegex$delegate;
    @NotNull
    private static final List<String> EXCEPTIONS_IGNORED_BY_DEFAULT;

    public SwallowedException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SwallowedException", Severity.CodeSmell, "The caught exception is swallowed. The original exception could be lost.", Debt.Companion.getTWENTY_MINS());
        this.ignoredExceptionTypes$delegate = ConfigPropertyKt.config(EXCEPTIONS_IGNORED_BY_DEFAULT, (Function1)ignoredExceptionTypes.2.INSTANCE);
        this.allowedExceptionNameRegex$delegate = ConfigPropertyKt.config((Object)"_|(ignore|expected).*", (Function1)allowedExceptionNameRegex.2.INSTANCE);
    }

    public /* synthetic */ SwallowedException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getIgnoredExceptionTypes() {
        return (List)this.ignoredExceptionTypes$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="exception types which should be ignored (both in the catch clause and body)")
    private static /* synthetic */ void getIgnoredExceptionTypes$annotations() {
    }

    private final Regex getAllowedExceptionNameRegex() {
        return (Regex)this.allowedExceptionNameRegex$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores too generic exception types which match this regex")
    private static /* synthetic */ void getAllowedExceptionNameRegex$annotations() {
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        KtParameter ktParameter = catchClause.getCatchParameter();
        if (ktParameter != null) {
            boolean bl;
            KtParameter catchParameter;
            block5: {
                catchParameter = ktParameter;
                boolean bl2 = false;
                KtTypeReference ktTypeReference = catchParameter.getTypeReference();
                String exceptionType = ktTypeReference != null ? ktTypeReference.getText() : null;
                Iterable $this$any$iv = this.getIgnoredExceptionTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string = exceptionType;
                        boolean bl4 = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)it, (boolean)true) : false;
                        if (!bl4) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl && this.isExceptionSwallowedOrUnused(catchClause) && !AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchParameter), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
        super.visitCatchSection(catchClause);
    }

    private final boolean isExceptionSwallowedOrUnused(KtCatchClause catchClause) {
        return this.isExceptionUnused(catchClause) || this.isExceptionSwallowed(catchClause);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionUnused(KtCatchClause catchClause) {
        void $this$anyDescendantOfType$iv;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression == null) {
            return true;
        }
        KtExpression catchBody = ktExpression;
        PsiElement psiElement = (PsiElement)catchBody;
        Function1 predicate$iv = (Function1)new Function1<KtNameReferenceExpression, Boolean>(this, parameterName){
            final /* synthetic */ SwallowedException this$0;
            final /* synthetic */ String $parameterName;
            {
                this.this$0 = $receiver;
                this.$parameterName = $parameterName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNameReferenceExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SwallowedException.access$getIgnoredExceptionTypes(this.this$0).contains(it.getText()) || Intrinsics.areEqual((Object)it.getText(), (Object)this.$parameterName);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionSwallowed(KtCatchClause catchClause) {
        boolean bl;
        KtExpression catchBody;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchBody = catchClause.getCatchBody();
        if (ktExpression != null) {
            void $this$anyDescendantOfType$iv;
            PsiElement psiElement = (PsiElement)ktExpression;
            Function1 predicate$iv = (Function1)new Function1<KtThrowExpression, Boolean>(this, parameterName, catchBody){
                final /* synthetic */ SwallowedException this$0;
                final /* synthetic */ String $parameterName;
                final /* synthetic */ KtExpression $catchBody;
                {
                    this.this$0 = $receiver;
                    this.$parameterName = $parameterName;
                    this.$catchBody = $catchBody;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull KtThrowExpression throwExpr) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)throwExpr, (String)"throwExpr");
                    List parameterReferences = SwallowedException.access$parameterReferences(this.this$0, throwExpr, this.$parameterName, this.$catchBody);
                    if (!((Collection)parameterReferences).isEmpty()) {
                        boolean bl2;
                        block5: {
                            Iterable $this$all$iv = parameterReferences;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    KtExpression it = (KtExpression)element$iv;
                                    boolean bl3 = false;
                                    if (it instanceof KtDotQualifiedExpression) continue;
                                    bl2 = false;
                                    break block5;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            };
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> parameterReferences(KtThrowExpression $this$parameterReferences, String parameterName, KtExpression catchBody) {
        List list;
        List list2;
        Map parameterReferencesInVariables = new LinkedHashMap();
        KtExpression ktExpression = $this$parameterReferences.getThrownExpression();
        if (ktExpression != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Iterable $this$collectDescendantsOfType_u24default$iv;
            PsiElement psiElement = (PsiElement)ktExpression;
            Function1 predicate$iv = parameterReferences$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType22 = false;
            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType = false;
            void var11_13 = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var14_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            $this$collectDescendantsOfType_u24default$iv = (List)to$iv$iv$iv;
            boolean $i$f$mapNotNull = false;
            void $i$f$collectDescendantsOfType22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtExpression ktExpression2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtNameReferenceExpression reference2 = (KtNameReferenceExpression)element$iv$iv;
                boolean bl2 = false;
                String referenceText = reference2.getText();
                if (Intrinsics.areEqual((Object)referenceText, (Object)parameterName)) {
                    ktExpression2 = KtPsiUtilKt.getQualifiedExpressionForReceiverOrThis((KtExpression)((KtExpression)reference2));
                } else {
                    ktExpression2 = (KtExpression)parameterReferencesInVariables.get(referenceText);
                    if (ktExpression2 == null) {
                        KtExpression ktExpression3 = (KtExpression)reference2;
                        Intrinsics.checkNotNullExpressionValue((Object)referenceText, (String)"referenceText");
                        if (this.findReferenceInVariable(ktExpression3, parameterName, referenceText, catchBody) != null) {
                            KtExpression ktExpression4;
                            KtExpression it = ktExpression4;
                            boolean bl3 = false;
                            parameterReferencesInVariables.put(referenceText, it);
                            ktExpression2 = ktExpression4;
                        } else {
                            ktExpression2 = null;
                        }
                    }
                }
                if (ktExpression2 == null) continue;
                KtExpression it$iv$iv = ktExpression2;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final KtExpression findReferenceInVariable(KtExpression $this$findReferenceInVariable, String referenceName, String variableName, KtExpression catchBody) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$findReferenceInVariable;
        boolean $i$f$getStrictParentOfType = false;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression block = ktBlockExpression;
        return SwallowedException.findReferenceInVariable$find(catchBody, variableName, referenceName, block);
    }

    /*
     * WARNING - void declaration
     */
    private static final KtExpression findReferenceInVariable$find(KtExpression $catchBody, String $variableName, String $referenceName, KtBlockExpression block) {
        Object object;
        void $this$findDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)block;
        Function1 predicate$iv = (Function1)new Function1<KtProperty, Boolean>($variableName){
            final /* synthetic */ String $variableName;
            {
                this.$variableName = $variableName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtProperty it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$variableName);
            }
        };
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtProperty && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        KtProperty ktProperty = (KtProperty)((PsiElement)result$iv$iv.element);
        if (ktProperty != null) {
            KtExpression it;
            KtProperty property = ktProperty;
            boolean bl = false;
            KtExpression initializer = property.getInitializer();
            if (initializer instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = initializer;
                it = (KtDotQualifiedExpression)ktExpression;
                boolean bl2 = false;
                object = Intrinsics.areEqual((Object)it.getReceiverExpression().getText(), (Object)$referenceName) ? ktExpression : null;
            } else {
                KtExpression ktExpression;
                it = ktExpression = initializer;
                boolean bl3 = false;
                KtExpression ktExpression2 = it;
                object = Intrinsics.areEqual((Object)(ktExpression2 != null ? ktExpression2.getText() : null), (Object)$referenceName) ? ktExpression : null;
            }
        } else {
            object = null;
        }
        KtExpression reference2 = object;
        KtExpression ktExpression = reference2;
        if (ktExpression == null) {
            if (Intrinsics.areEqual((Object)block, (Object)$catchBody)) {
                ktExpression = null;
            } else {
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)block;
                boolean $i$f$getStrictParentOfType = false;
                KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBlockExpression.class, (boolean)true);
                if (ktBlockExpression != null) {
                    KtBlockExpression it = ktBlockExpression;
                    boolean bl = false;
                    ktExpression = SwallowedException.findReferenceInVariable$find($catchBody, $variableName, $referenceName, it);
                } else {
                    ktExpression = null;
                }
            }
        }
        return ktExpression;
    }

    public SwallowedException() {
        this(null, 1, null);
    }

    @NotNull
    public static final List<String> getEXCEPTIONS_IGNORED_BY_DEFAULT() {
        return Companion.getEXCEPTIONS_IGNORED_BY_DEFAULT();
    }

    public static final /* synthetic */ List access$getIgnoredExceptionTypes(SwallowedException $this) {
        return $this.getIgnoredExceptionTypes();
    }

    public static final /* synthetic */ List access$parameterReferences(SwallowedException $this, KtThrowExpression $receiver, String parameterName, KtExpression catchBody) {
        return $this.parameterReferences($receiver, parameterName, catchBody);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SwallowedException.class, "ignoredExceptionTypes", "getIgnoredExceptionTypes()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(SwallowedException.class, "allowedExceptionNameRegex", "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"InterruptedException", "MalformedURLException", "NumberFormatException", "ParseException"};
        EXCEPTIONS_IGNORED_BY_DEFAULT = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException$Companion;", "", "()V", "EXCEPTIONS_IGNORED_BY_DEFAULT", "", "", "getEXCEPTIONS_IGNORED_BY_DEFAULT$annotations", "getEXCEPTIONS_IGNORED_BY_DEFAULT", "()Ljava/util/List;", "detekt-rules-exceptions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCEPTIONS_IGNORED_BY_DEFAULT() {
            return EXCEPTIONS_IGNORED_BY_DEFAULT;
        }

        @JvmStatic
        public static /* synthetic */ void getEXCEPTIONS_IGNORED_BY_DEFAULT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

