/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.libraries;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/libraries/ForbiddenPublicDataClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignorePackages", "", "Lkotlin/text/Regex;", "getIgnorePackages$annotations", "()V", "getIgnorePackages", "()Ljava/util/List;", "ignorePackages$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "detekt-rules-libraries"})
@SourceDebugExtension(value={"SMAP\nForbiddenPublicDataClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenPublicDataClass.kt\nio/gitlab/arturbosch/detekt/libraries/ForbiddenPublicDataClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1755#2,3:67\n1557#2:70\n1628#2,3:71\n*S KotlinDebug\n*F\n+ 1 ForbiddenPublicDataClass.kt\nio/gitlab/arturbosch/detekt/libraries/ForbiddenPublicDataClass\n*L\n51#1:67,3\n45#1:70\n45#1:71,3\n*E\n"})
public final class ForbiddenPublicDataClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignorePackages$delegate;

    public ForbiddenPublicDataClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The data classes are bad for the binary compatibility in public APIs. Avoid to use it.", Debt.Companion.getTWENTY_MINS());
        Object[] objectArray = new String[]{"*.internal", "*.internal.*"};
        this.ignorePackages$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), ForbiddenPublicDataClass::ignorePackages_delegate$lambda$0);
    }

    public /* synthetic */ ForbiddenPublicDataClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getIgnorePackages() {
        return (List)this.ignorePackages$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores classes in the specified packages.")
    private static /* synthetic */ void getIgnorePackages$annotations() {
    }

    public void visitClass(@NotNull KtClass klass) {
        String packageName;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        KtPackageDirective ktPackageDirective = klass.getContainingKtFile().getPackageDirective();
        String string = ktPackageDirective != null && (ktPackageDirective = ktPackageDirective.getPackageNameExpression()) != null ? ktPackageDirective.getText() : (packageName = null);
        if (packageName != null) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.getIgnorePackages();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!it.matches((CharSequence)packageName)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        KtModifierKeywordToken visibility = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)klass));
        boolean bl = false;
        boolean bl3 = !Intrinsics.areEqual((Object)visibility, (Object)KtTokens.INTERNAL_KEYWORD) && !Intrinsics.areEqual((Object)visibility, (Object)KtTokens.PRIVATE_KEYWORD);
        boolean isPublicOrProtected = bl3;
        if (isPublicOrProtected) {
            if (klass.isData()) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), "", null, null, 24, null));
            }
            super.visitClass(klass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignorePackages_delegate$lambda$0(List packages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packages, (String)"packages");
        Iterable $this$map$iv = CollectionsKt.distinct((Iterable)packages);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$ignorePackages_delegate$lambda$0$stub_for_inlining = false;
            collection.add(SplitPatternKt.simplePatternToRegex((String)p0));
        }
        return (List)destination$iv$iv;
    }

    public ForbiddenPublicDataClass() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenPublicDataClass.class, "ignorePackages", "getIgnorePackages()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

