/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.libraries;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtExpressionKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.ExplicitApiDeclarationChecker;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u000b*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u000b*\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/libraries/LibraryCodeMustSpecifyReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "allowOmitUnit", "", "getAllowOmitUnit$annotations", "()V", "getAllowOmitUnit", "()Z", "allowOmitUnit$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isUnitOmissionAllowed", "explicitReturnTypeRequired", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "detekt-rules-libraries"})
public final class LibraryCodeMustSpecifyReturnType
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowOmitUnit$delegate;

    public LibraryCodeMustSpecifyReturnType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Library functions/properties should have an explicit return type. Inferred return types can easily be changed by mistake which may lead to breaking changes.", Debt.Companion.getFIVE_MINS());
        this.allowOmitUnit$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ LibraryCodeMustSpecifyReturnType(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowOmitUnit() {
        return (Boolean)this.allowOmitUnit$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if functions with `Unit` return type should be allowed without return type declaration")
    private static /* synthetic */ void getAllowOmitUnit$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.explicitReturnTypeRequired((KtCallableDeclaration)property)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), "Library property '" + property.getNameAsSafeName() + "' without explicit return type.", null, null, 24, null));
        }
        super.visitProperty(property);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (this.explicitReturnTypeRequired((KtCallableDeclaration)function) && !this.isUnitOmissionAllowed(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "Library function '" + function.getNameAsSafeName() + "' without explicit return type.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isUnitOmissionAllowed(KtNamedFunction $this$isUnitOmissionAllowed) {
        KtExpression bodyExpression = $this$isUnitOmissionAllowed.getBodyExpression();
        if (bodyExpression == null || KtExpressionKt.isUnitExpression((KtExpression)bodyExpression)) {
            return true;
        }
        return this.getAllowOmitUnit() && MethodSignatureKt.hasImplicitUnitReturnType((KtNamedFunction)$this$isUnitOmissionAllowed, (BindingContext)this.getBindingContext());
    }

    private final boolean explicitReturnTypeRequired(KtCallableDeclaration $this$explicitReturnTypeRequired) {
        return ExplicitApiDeclarationChecker.Companion.returnTypeCheckIsApplicable($this$explicitReturnTypeRequired) && ExplicitApiDeclarationChecker.Companion.returnTypeRequired($this$explicitReturnTypeRequired, (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$explicitReturnTypeRequired), true, false, false);
    }

    public LibraryCodeMustSpecifyReturnType() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LibraryCodeMustSpecifyReturnType.class, "allowOmitUnit", "getAllowOmitUnit()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

