/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.ConstructorParameterNaming;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\f\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\f\u0012\u0004\b\u0018\u0010\b\u001a\u0004\b\u0019\u0010\nR!\u0010\u001b\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\f\u0012\u0004\b\u001c\u0010\b\u001a\u0004\b\u001d\u0010\n\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ConstructorParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern$annotations", "()V", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "getParameterPattern$annotations", "getParameterPattern", "parameterPattern$delegate", "privateParameterPattern", "getPrivateParameterPattern$annotations", "getPrivateParameterPattern", "privateParameterPattern$delegate", "isIgnoreOverridden", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitParameter", "", "detekt-rules-naming"})
public final class ConstructorParameterNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty parameterPattern$delegate;
    @NotNull
    private final ReadOnlyProperty privateParameterPattern$delegate;
    @NotNull
    private final ReadOnlyProperty excludeClassPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;

    public ConstructorParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Constructor parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", (Function1)parameterPattern.2.INSTANCE);
        this.privateParameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", (Function1)privateParameterPattern.2.INSTANCE);
        this.excludeClassPattern$delegate = ConfigPropertyKt.config((Object)"$^", (Function1)excludeClassPattern.2.INSTANCE);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ ConstructorParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return (Regex)this.parameterPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    private final Regex getPrivateParameterPattern() {
        return (Regex)this.privateParameterPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivateParameterPattern$annotations() {
    }

    private final Regex getExcludeClassPattern() {
        return (Regex)this.excludeClassPattern$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores variables in classes which match this regex")
    private static /* synthetic */ void getExcludeClassPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignores constructor properties that have the override modifier")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)parameter, this.getExcludeClassPattern()) || this.isIgnoreOverridden(parameter)) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)parameter));
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)parameter))) {
            CharSequence charSequence = identifier;
            Regex regex = this.getPrivateParameterPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), Intrinsics.stringPlus((String)"Constructor private parameter names should match the pattern: ", (Object)this.getPrivateParameterPattern()), null, null, 24, null));
            }
        } else {
            CharSequence charSequence = identifier;
            Regex regex = this.getParameterPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), Intrinsics.stringPlus((String)"Constructor parameter names should match the pattern: ", (Object)this.getParameterPattern()), null, null, 24, null));
            }
        }
    }

    private final boolean isIgnoreOverridden(KtParameter parameter) {
        return this.getIgnoreOverridden() && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)parameter));
    }

    public ConstructorParameterNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "parameterPattern", "getParameterPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "privateParameterPattern", "getPrivateParameterPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "excludeClassPattern", "getExcludeClassPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

