/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.naming.LambdaParameterNaming;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/LambdaParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "Lkotlin/text/Regex;", "getParameterPattern$annotations", "()V", "getParameterPattern", "()Lkotlin/text/Regex;", "parameterPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "detekt-rules-naming"})
public final class LambdaParameterNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty parameterPattern$delegate;

    public LambdaParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Lambda parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*|_", (Function1)parameterPattern.2.INSTANCE);
    }

    public /* synthetic */ LambdaParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return (Regex)this.parameterPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitParameter(@NotNull KtParameter parameter) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        KtDestructuringDeclaration ktDestructuringDeclaration = parameter.getDestructuringDeclaration();
        List list = ktDestructuringDeclaration == null ? null : ktDestructuringDeclaration.getEntries();
        List parameters = list == null ? CollectionsKt.listOf((Object)parameter) : list;
        Iterable $this$mapNotNull$iv = parameters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            PsiElement psiElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (it.getNameIdentifier() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv = psiElement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            String identifier = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
            object = identifier;
            Regex regex = this.getParameterPattern();
            boolean bl6 = false;
            if (regex.matches((CharSequence)object)) continue;
            Issue issue = this.getIssue();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)it, (int)0, (int)2, null), Intrinsics.stringPlus((String)"Lambda parameter names should match the pattern: ", (Object)this.getParameterPattern()), null, null, 24, null));
        }
    }

    public LambdaParameterNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LambdaParameterNaming.class, "parameterPattern", "getParameterPattern()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

