/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtLambdaExpressionKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/NoNameShadowing;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkNameShadowing", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitDestructuringDeclarationEntry", "multiDeclarationEntry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "hasParentImplicitParameterLambda", "", "detekt-rules-naming"})
public final class NoNameShadowing
extends Rule {
    @NotNull
    private final Issue issue;

    public NoNameShadowing(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "Disallow shadowing variable declarations.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NoNameShadowing(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        this.checkNameShadowing((KtNamedDeclaration)property);
    }

    public void visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry multiDeclarationEntry) {
        Intrinsics.checkNotNullParameter((Object)multiDeclarationEntry, (String)"multiDeclarationEntry");
        super.visitDestructuringDeclarationEntry(multiDeclarationEntry);
        this.checkNameShadowing((KtNamedDeclaration)multiDeclarationEntry);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        this.checkNameShadowing((KtNamedDeclaration)parameter);
    }

    private final void checkNameShadowing(KtNamedDeclaration declaration) {
        PsiElement psiElement = declaration.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        if (!Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = this.getBindingContext().getDiagnostics().forElement((PsiElement)declaration);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.NAME_SHADOWING)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)nameIdentifier, (int)0, (int)2, null), "Name shadowed: " + nameIdentifier.getText(), null, null, 24, null));
            }
        }
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        ValueParameterDescriptor valueParameterDescriptor = KtLambdaExpressionKt.implicitParameter((KtLambdaExpression)lambdaExpression, (BindingContext)this.getBindingContext());
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor implicitParameter = valueParameterDescriptor;
        if (KtLambdaExpressionKt.hasImplicitParameterReference((KtLambdaExpression)lambdaExpression, (ValueParameterDescriptor)implicitParameter, (BindingContext)this.getBindingContext()) && this.hasParentImplicitParameterLambda(lambdaExpression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), "Name shadowed: implicit lambda parameter 'it'", null, null, 24, null));
        }
    }

    private final boolean hasParentImplicitParameterLambda(KtLambdaExpression $this$hasParentImplicitParameterLambda) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$hasParentImplicitParameterLambda;
        boolean $i$f$getStrictParentOfType = false;
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLambdaExpression.class, (boolean)true);
        return (ktLambdaExpression != null ? KtLambdaExpressionKt.implicitParameter((KtLambdaExpression)ktLambdaExpression, (BindingContext)this.getBindingContext()) : null) != null;
    }

    public NoNameShadowing() {
        this(null, 1, null);
    }
}

