/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\n*\u00020\rH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\rH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/NonBooleanPropertyPrefixedWithIs;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "javaBooleanTypeName", "", "kotlinBooleanTypeName", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "parameter", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "reportCodeSmell", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "declaration", "name", "typeName", "validateDeclaration", "", "visitParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getTypeName", "isBooleanFunctionReference", "", "detekt-rules-naming"})
public final class NonBooleanPropertyPrefixedWithIs
extends Rule {
    @NotNull
    private final String kotlinBooleanTypeName;
    @NotNull
    private final String javaBooleanTypeName;
    @NotNull
    private final Issue issue;

    public NonBooleanPropertyPrefixedWithIs(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.kotlinBooleanTypeName = "kotlin.Boolean";
        this.javaBooleanTypeName = "java.lang.Boolean";
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "Only boolean property names can start with `is` prefix.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NonBooleanPropertyPrefixedWithIs(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        if (parameter.hasValOrVar()) {
            this.validateDeclaration((KtCallableDeclaration)parameter);
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        this.validateDeclaration((KtCallableDeclaration)property);
    }

    private final void validateDeclaration(KtCallableDeclaration declaration) {
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        String name = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)declaration));
        if (StringsKt.startsWith$default((String)name, (String)"is", (boolean)false, (int)2, null) && name.length() > 2 && !Character.isLowerCase(name.charAt(2))) {
            KotlinType type;
            KotlinType kotlinType = type = this.getType(declaration);
            String typeName = kotlinType != null ? this.getTypeName(kotlinType) : null;
            boolean isNotBooleanType = !Intrinsics.areEqual((Object)typeName, (Object)this.kotlinBooleanTypeName) && !Intrinsics.areEqual((Object)typeName, (Object)this.javaBooleanTypeName);
            CharSequence charSequence = typeName;
            if (!(charSequence == null || charSequence.length() == 0) && isNotBooleanType && !this.isBooleanFunctionReference(type)) {
                this.report((Finding)this.reportCodeSmell(declaration, name, typeName));
            }
        }
    }

    private final CodeSmell reportCodeSmell(KtCallableDeclaration declaration, String name, String typeName) {
        return new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), "Non-boolean properties shouldn't start with 'is' prefix. Actual type of " + name + ": " + typeName, null, null, 24, null);
    }

    private final KotlinType getType(KtCallableDeclaration parameter) {
        TypeBinding typeBinding = TypeBindingKt.createTypeBindingForReturnType((KtCallableDeclaration)parameter, (BindingContext)this.getBindingContext());
        return typeBinding != null ? typeBinding.getType() : null;
    }

    private final String getTypeName(KotlinType $this$getTypeName) {
        FqName fqName = TypeUtilsKt.fqNameOrNull((KotlinType)$this$getTypeName);
        return fqName != null ? fqName.asString() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBooleanFunctionReference(KotlinType $this$isBooleanFunctionReference) {
        if (!FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability((KotlinType)$this$isBooleanFunctionReference)) {
            return false;
        }
        if (((Collection)$this$isBooleanFunctionReference.getArguments()).size() != 1) return false;
        KotlinType kotlinType = ((TypeProjection)$this$isBooleanFunctionReference.getArguments().get(0)).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments[0].type");
        if (!org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.isBoolean((KotlinType)kotlinType)) return false;
        return true;
    }

    public NonBooleanPropertyPrefixedWithIs() {
        this(null, 1, null);
    }
}

