/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.TopLevelPropertyNaming;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR!\u0010\u0015\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\f\u0012\u0004\b\u0016\u0010\b\u001a\u0004\b\u0017\u0010\n\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/TopLevelPropertyNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "constantPattern", "Lkotlin/text/Regex;", "getConstantPattern$annotations", "()V", "getConstantPattern", "()Lkotlin/text/Regex;", "constantPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "privatePropertyPattern", "getPrivatePropertyPattern$annotations", "getPrivatePropertyPattern", "privatePropertyPattern$delegate", "propertyPattern", "getPropertyPattern$annotations", "getPropertyPattern", "propertyPattern$delegate", "handleConstant", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "handleProperty", "report", "message", "", "visitProperty", "Companion", "detekt-rules-naming"})
public final class TopLevelPropertyNaming
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty constantPattern$delegate;
    @NotNull
    private final ReadOnlyProperty propertyPattern$delegate;
    @NotNull
    private final ReadOnlyProperty privatePropertyPattern$delegate;
    @NotNull
    public static final String CONSTANT_PATTERN = "constantPattern";

    public TopLevelPropertyNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Top level property names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.constantPattern$delegate = ConfigPropertyKt.config((Object)"[A-Z][_A-Z0-9]*", (Function1)constantPattern.2.INSTANCE);
        this.propertyPattern$delegate = ConfigPropertyKt.config((Object)"[A-Za-z][_A-Za-z0-9]*", (Function1)propertyPattern.2.INSTANCE);
        this.privatePropertyPattern$delegate = ConfigPropertyKt.config((Object)"_?[A-Za-z][_A-Za-z0-9]*", (Function1)privatePropertyPattern.2.INSTANCE);
    }

    public /* synthetic */ TopLevelPropertyNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getConstantPattern() {
        return (Regex)this.constantPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getConstantPattern$annotations() {
    }

    private final Regex getPropertyPattern() {
        return (Regex)this.propertyPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPropertyPattern$annotations() {
    }

    private final Regex getPrivatePropertyPattern() {
        return (Regex)this.privatePropertyPattern$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivatePropertyPattern$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)property))) {
            this.handleConstant(property);
        } else {
            this.handleProperty(property);
        }
    }

    private final void handleConstant(KtProperty property) {
        CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
        if (!this.getConstantPattern().matches(charSequence)) {
            this.report(property, "Top level constant names should match the pattern: " + this.getConstantPattern());
        }
    }

    private final void handleProperty(KtProperty property) {
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property))) {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            if (!this.getPrivatePropertyPattern().matches(charSequence)) {
                this.report(property, "Private top level property names should match the pattern: " + this.getPrivatePropertyPattern());
            }
        } else {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            if (!this.getPropertyPattern().matches(charSequence)) {
                this.report(property, "Top level property names should match the pattern: " + this.getPropertyPattern());
            }
        }
    }

    private final void report(KtProperty property, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), message, null, null, 24, null));
    }

    public TopLevelPropertyNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, CONSTANT_PATTERN, "getConstantPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, "propertyPattern", "getPropertyPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, "privatePropertyPattern", "getPrivatePropertyPattern()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/TopLevelPropertyNaming$Companion;", "", "()V", "CONSTANT_PATTERN", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

