/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import io.gitlab.arturbosch.detekt.rules.naming.BooleanPropertyNaming;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\f\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/BooleanPropertyNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPattern", "Lkotlin/text/Regex;", "getAllowedPattern$annotations", "()V", "getAllowedPattern", "()Lkotlin/text/Regex;", "allowedPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getTypeName", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isIgnoreOverridden", "declaration", "reportCodeSmell", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "name", "validateDeclaration", "", "visitParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-naming"})
public final class BooleanPropertyNaming
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty allowedPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String KOTLIN_BOOLEAN_TYPE_NAME = "kotlin.Boolean";
    @NotNull
    public static final String JAVA_BOOLEAN_TYPE_NAME = "java.lang.Boolean";

    public BooleanPropertyNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.allowedPattern$delegate = ConfigPropertyKt.config((Object)"^(is|has|are)", (Function1)allowedPattern.2.INSTANCE);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)true);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.CodeSmell, "Boolean property name should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ BooleanPropertyNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    private final Regex getAllowedPattern() {
        return (Regex)this.allowedPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getAllowedPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores properties that have the override modifier")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        if (parameter.hasValOrVar()) {
            this.validateDeclaration((KtCallableDeclaration)parameter);
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        this.validateDeclaration((KtCallableDeclaration)property);
    }

    private final void validateDeclaration(KtCallableDeclaration declaration) {
        boolean isNonConstantBooleanType;
        String name = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)declaration));
        String typeName = this.getTypeName(declaration);
        boolean isBooleanType = Intrinsics.areEqual((Object)typeName, (Object)KOTLIN_BOOLEAN_TYPE_NAME) || Intrinsics.areEqual((Object)typeName, (Object)JAVA_BOOLEAN_TYPE_NAME);
        boolean bl = isNonConstantBooleanType = isBooleanType && !KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)declaration));
        if (isNonConstantBooleanType) {
            CharSequence charSequence = name;
            if (!this.getAllowedPattern().containsMatchIn(charSequence) && !this.isIgnoreOverridden(declaration)) {
                this.report((Finding)this.reportCodeSmell(declaration, name));
            }
        }
    }

    private final CodeSmell reportCodeSmell(KtCallableDeclaration declaration, String name) {
        String description = "Boolean property name should match a " + this.getAllowedPattern() + " pattern.";
        return new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)declaration), description + " Actual name is " + name, null, null, 24, null);
    }

    private final String getTypeName(KtCallableDeclaration parameter) {
        KotlinType kotlinType;
        TypeBinding typeBinding = TypeBindingKt.createTypeBindingForReturnType((KtCallableDeclaration)parameter, (BindingContext)this.getBindingContext());
        return String.valueOf(typeBinding != null && (kotlinType = typeBinding.getType()) != null ? TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType) : null);
    }

    private final boolean isIgnoreOverridden(KtCallableDeclaration declaration) {
        return this.getIgnoreOverridden() && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)declaration));
    }

    public BooleanPropertyNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BooleanPropertyNaming.class, "allowedPattern", "getAllowedPattern()Lkotlin/text/Regex;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BooleanPropertyNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/BooleanPropertyNaming$Companion;", "", "()V", "JAVA_BOOLEAN_TYPE_NAME", "", "KOTLIN_BOOLEAN_TYPE_NAME", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

