/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\u001c*\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0014\u0010\"\u001a\u00020\u000f*\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020\u0007\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0'H\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070)*\u00020#2\u0006\u0010*\u001a\u00020#H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0016\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0015\u0012\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "requireRootInDeclaration", "", "getRequireRootInDeclaration$annotations", "()V", "getRequireRootInDeclaration", "()Z", "requireRootInDeclaration$delegate", "Lkotlin/properties/ReadOnlyProperty;", "rootPackage", "getRootPackage$annotations", "getRootPackage", "()Ljava/lang/String;", "rootPackage$delegate", "visitPackageDirective", "", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "reportInvalidPackageDeclaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "message", "startsWith", "Lorg/jetbrains/kotlin/name/FqName;", "other", "toNormalizedForm", "T", "", "withoutPrefix", "", "prefix", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nInvalidPackageDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidPackageDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1726#2,3:85\n1549#2:88\n1620#2,3:89\n*S KotlinDebug\n*F\n+ 1 InvalidPackageDeclaration.kt\nio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration\n*L\n71#1:85,3\n81#1:88\n81#1:89,3\n*E\n"})
public final class InvalidPackageDeclaration
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty rootPackage$delegate;
    @NotNull
    private final ReadOnlyProperty requireRootInDeclaration$delegate;

    public InvalidPackageDeclaration(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"PackageDirectoryMismatch");
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Kotlin source files should be stored in the directory corresponding to its package statement.", Debt.Companion.getFIVE_MINS());
        this.rootPackage$delegate = ConfigPropertyKt.config((Object)"");
        this.requireRootInDeclaration$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ InvalidPackageDeclaration(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final String getRootPackage() {
        return (String)this.rootPackage$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if specified this part of the package structure is ignored")
    private static /* synthetic */ void getRootPackage$annotations() {
    }

    private final boolean getRequireRootInDeclaration() {
        return (Boolean)this.requireRootInDeclaration$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="requires the declaration to start with the specified rootPackage")
    private static /* synthetic */ void getRequireRootInDeclaration$annotations() {
    }

    public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        super.visitPackageDirective(directive);
        FqName fqName = directive.getFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"directive.fqName");
        FqName packageName = fqName;
        if (!packageName.isRoot()) {
            boolean isInRootPackage;
            FqName rootPackageName = new FqName(this.getRootPackage());
            if (this.getRequireRootInDeclaration() && !this.startsWith(packageName, rootPackageName)) {
                this.reportInvalidPackageDeclaration((KtElement)directive, "The package declaration is missing the root package");
                return;
            }
            KtFile ktFile = directive.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"directive.containingKtFile");
            Path path = KtFilesKt.absolutePath((PsiFile)((PsiFile)ktFile)).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"directive.containingKtFile.absolutePath().parent");
            String normalizedFilePath = this.toNormalizedForm(path);
            String expectedPath = this.toNormalizedForm((Iterable)this.withoutPrefix(packageName, rootPackageName));
            boolean bl = isInRootPackage = ((CharSequence)expectedPath).length() == 0;
            if (!isInRootPackage && !StringsKt.endsWith$default((String)normalizedFilePath, (String)('|' + expectedPath), (boolean)false, (int)2, null)) {
                this.reportInvalidPackageDeclaration((KtElement)directive, "The package declaration does not match the actual file location.");
            }
        }
    }

    private final void reportInvalidPackageDeclaration(KtElement $this$reportInvalidPackageDeclaration, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)$this$reportInvalidPackageDeclaration), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final <T> String toNormalizedForm(Iterable<? extends T> $this$toNormalizedForm) {
        return CollectionsKt.joinToString$default($this$toNormalizedForm, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean startsWith(FqName $this$startsWith, FqName other) {
        boolean bl;
        block5: {
            List list = $this$startsWith.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathSegments()");
            List segments = list;
            List list2 = other.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"other.pathSegments()");
            List otherSegments = list2;
            if (otherSegments.size() <= segments.size()) {
                Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)otherSegments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int index = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(segments.get(index), otherSegments.get(index))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> withoutPrefix(FqName $this$withoutPrefix, FqName prefix) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int dropCount = this.startsWith($this$withoutPrefix, prefix) ? prefix.pathSegments().size() : 0;
        List list = $this$withoutPrefix.pathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pathSegments()");
        Iterable iterable = CollectionsKt.drop((Iterable)list, (int)dropCount);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void segmentName;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(segmentName.asString());
        }
        return (List)destination$iv$iv;
    }

    public InvalidPackageDeclaration() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(InvalidPackageDeclaration.class, "rootPackage", "getRootPackage()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(InvalidPackageDeclaration.class, "requireRootInDeclaration", "getRequireRootInDeclaration()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

