/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u0012\u0004\b\u0010\u0010\n\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "classMessage", "", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "()V", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverriddenFunction", "getIgnoreOverriddenFunction$annotations", "getIgnoreOverriddenFunction", "ignoreOverriddenFunction$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "objectMessage", "getMisnamedCompanionObjectMembers", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getMisnamedMembers", "klassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "name", "isFactoryMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nMemberNameEqualsClassName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberNameEqualsClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,127:1\n1295#2,2:128\n1295#2,2:130\n*S KotlinDebug\n*F\n+ 1 MemberNameEqualsClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName\n*L\n83#1:128,2\n91#1:130,2\n*E\n"})
public final class MemberNameEqualsClassName
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final String classMessage;
    @NotNull
    private final String objectMessage;
    @NotNull
    private final ReadOnlyProperty ignoreOverriddenFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;

    public MemberNameEqualsClassName(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A member should not be given the same name as its parent class or object.", Debt.Companion.getFIVE_MINS());
        this.classMessage = "A member is named after the class. This might result in confusion. Either rename the member or change it to a constructor.";
        this.objectMessage = "A member is named after the object. This might result in confusion. Please rename the member.";
        this.ignoreOverriddenFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreOverridden$delegate = ConfigPropertyKt.configWithFallback((KProperty0)((KProperty0)new PropertyReference0Impl((Object)this){

            @Nullable
            public Object get() {
                return MemberNameEqualsClassName.access$getIgnoreOverriddenFunction((MemberNameEqualsClassName)((Object)this.receiver));
            }
        }), (Object)true);
    }

    public /* synthetic */ MemberNameEqualsClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverriddenFunction() {
        return (Boolean)this.ignoreOverriddenFunction$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if overridden functions and properties should be ignored")
    @Deprecated(message="Use `ignoreOverridden` instead")
    private static /* synthetic */ void getIgnoreOverriddenFunction$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if overridden functions and properties should be ignored")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isInterface()) {
            Sequence $this$forEach$iv = SequencesKt.plus(this.getMisnamedMembers((KtClassOrObject)klass, klass.getName()), this.getMisnamedCompanionObjectMembers(klass));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.classMessage, null, null, 24, null));
            }
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isCompanion()) {
            Sequence<KtNamedDeclaration> $this$forEach$iv = this.getMisnamedMembers((KtClassOrObject)declaration, declaration.getName());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.objectMessage, null, null, 24, null));
            }
        }
        super.visitObjectDeclaration(declaration);
    }

    private final Sequence<KtNamedDeclaration> getMisnamedMembers(KtClassOrObject klassOrObject, String name) {
        KtClassBody ktClassBody = klassOrObject.getBody();
        if (ktClassBody == null) {
            return SequencesKt.emptySequence();
        }
        KtClassBody body = ktClassBody;
        Sequence sequence = CollectionsKt.asSequence((Iterable)body.getFunctions());
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<org.jetbrains.kotlin.psi.KtNamedDeclaration>");
        return SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.plus((Sequence)sequence, (Iterable)body.getProperties()), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(this){
            final /* synthetic */ MemberNameEqualsClassName this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MemberNameEqualsClassName.access$getIgnoreOverridden(this.this$0) && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)it));
            }
        })), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                return string != null ? StringsKt.equals((String)string, (String)this.$name, (boolean)true) : false;
            }
        }));
    }

    private final Sequence<KtNamedDeclaration> getMisnamedCompanionObjectMembers(KtClass klass) {
        return SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)klass.getCompanionObjects()), (Function1)((Function1)new Function1<KtObjectDeclaration, Sequence<? extends KtNamedDeclaration>>(this, klass){
            final /* synthetic */ MemberNameEqualsClassName this$0;
            final /* synthetic */ KtClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(1);
            }

            @NotNull
            public final Sequence<KtNamedDeclaration> invoke(@NotNull KtObjectDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MemberNameEqualsClassName.access$getMisnamedMembers(this.this$0, (KtClassOrObject)it, this.$klass.getName());
            }
        })), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(this, klass){
            final /* synthetic */ MemberNameEqualsClassName this$0;
            final /* synthetic */ KtClass $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof KtNamedFunction && MemberNameEqualsClassName.access$isFactoryMethod(this.this$0, (KtNamedFunction)it, this.$klass);
            }
        }));
    }

    private final boolean isFactoryMethod(KtNamedFunction function, KtClass klass) {
        boolean bl;
        KtTypeReference typeReference = function.getTypeReference();
        if (typeReference != null) {
            KtTypeElement ktTypeElement = typeReference.getTypeElement();
            Object object = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
            if (object == null || (object = object.getReferencedName()) == null) {
                object = typeReference.getText();
            }
            Object refName = object;
            bl = Intrinsics.areEqual((Object)refName, (Object)klass.getName());
        } else if (function.getBodyExpression() instanceof KtBlockExpression) {
            bl = false;
        } else if (!(function.getBodyExpression() instanceof KtBlockExpression) && !Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function);
            DeclarationDescriptor classDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)klass);
            SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
            bl = Intrinsics.areEqual(simpleFunctionDescriptor != null && (simpleFunctionDescriptor = simpleFunctionDescriptor.getReturnType()) != null && (simpleFunctionDescriptor = simpleFunctionDescriptor.getConstructor()) != null ? simpleFunctionDescriptor.getDeclarationDescriptor() : null, (Object)classDescriptor);
        } else {
            bl = true;
        }
        return bl;
    }

    public MemberNameEqualsClassName() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreOverridden(MemberNameEqualsClassName $this) {
        return $this.getIgnoreOverridden();
    }

    public static final /* synthetic */ Sequence access$getMisnamedMembers(MemberNameEqualsClassName $this, KtClassOrObject klassOrObject, String name) {
        return $this.getMisnamedMembers(klassOrObject, name);
    }

    public static final /* synthetic */ boolean access$isFactoryMethod(MemberNameEqualsClassName $this, KtNamedFunction function, KtClass klass) {
        return $this.isFactoryMethod(function, klass);
    }

    public static final /* synthetic */ boolean access$getIgnoreOverriddenFunction(MemberNameEqualsClassName $this) {
        return $this.getIgnoreOverriddenFunction();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MemberNameEqualsClassName.class, "ignoreOverriddenFunction", "getIgnoreOverriddenFunction()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MemberNameEqualsClassName.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

