/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.VariableNaming;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\f\u0010&\u001a\u00020\u000e*\u00020\"H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\f\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\f\u0012\u0004\b\u0018\u0010\b\u001a\u0004\b\u0019\u0010\nR!\u0010\u001b\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\f\u0012\u0004\b\u001c\u0010\b\u001a\u0004\b\u001d\u0010\n\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern$annotations", "()V", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "privateVariablePattern", "getPrivateVariablePattern$annotations", "getPrivateVariablePattern", "privateVariablePattern$delegate", "variablePattern", "getVariablePattern$annotations", "getVariablePattern", "variablePattern$delegate", "report", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "message", "", "visitProperty", "isPropertyTopLevelOrInCompanion", "Companion", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nVariableNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/VariableNaming\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,94:1\n146#2:95\n*S KotlinDebug\n*F\n+ 1 VariableNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/VariableNaming\n*L\n75#1:95\n*E\n"})
public final class VariableNaming
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty variablePattern$delegate;
    @NotNull
    private final ReadOnlyProperty privateVariablePattern$delegate;
    @NotNull
    private final ReadOnlyProperty excludeClassPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";

    public VariableNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Variable names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.variablePattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", (Function1)variablePattern.2.INSTANCE);
        this.privateVariablePattern$delegate = ConfigPropertyKt.config((Object)"(_)?[a-z][A-Za-z0-9]*", (Function1)privateVariablePattern.2.INSTANCE);
        this.excludeClassPattern$delegate = ConfigPropertyKt.config((Object)"$^", (Function1)excludeClassPattern.2.INSTANCE);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ VariableNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getVariablePattern() {
        return (Regex)this.variablePattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getVariablePattern$annotations() {
    }

    private final Regex getPrivateVariablePattern() {
        return (Regex)this.privateVariablePattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivateVariablePattern$annotations() {
    }

    private final Regex getExcludeClassPattern() {
        return (Regex)this.excludeClassPattern$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores variables in classes which match this regex")
    private static /* synthetic */ void getExcludeClassPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignores member properties that have the override modifier")
    @Deprecated(message="This configuration is ignored and will be removed in the future")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.isPropertyTopLevelOrInCompanion(property)) {
            return;
        }
        if (UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)((KtNamedDeclaration)property)) || ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)property, this.getExcludeClassPattern())) {
            return;
        }
        if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)property))) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property))) {
            CharSequence charSequence = identifier;
            if (!this.getPrivateVariablePattern().matches(charSequence)) {
                this.report(property, "Private variable names should match the pattern: " + this.getPrivateVariablePattern());
            }
        } else {
            CharSequence charSequence = identifier;
            if (!this.getVariablePattern().matches(charSequence)) {
                this.report(property, "Variable names should match the pattern: " + this.getVariablePattern());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyTopLevelOrInCompanion(KtProperty $this$isPropertyTopLevelOrInCompanion) {
        if ($this$isPropertyTopLevelOrInCompanion.getNameAsSafeName().isSpecial()) return true;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isPropertyTopLevelOrInCompanion;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)false) != null) return true;
        if ($this$isPropertyTopLevelOrInCompanion.isTopLevel()) return true;
        PsiElement psiElement = $this$isPropertyTopLevelOrInCompanion.getNameIdentifier();
        PsiElement psiElement2 = psiElement;
        if (psiElement == null) return true;
        PsiElement psiElement3 = psiElement2.getParent();
        psiElement2 = psiElement3;
        if (psiElement3 == null) return true;
        Class<?> clazz = psiElement2.getClass();
        if (clazz != null) return false;
        return true;
    }

    private final void report(KtProperty property, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), message, null, null, 24, null));
    }

    public VariableNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VariableNaming.class, "variablePattern", "getVariablePattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VariableNaming.class, "privateVariablePattern", "getPrivateVariablePattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VariableNaming.class, EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VariableNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming$Companion;", "", "()V", "EXCLUDE_CLASS_PATTERN", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

