/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "excludeAnnotatedFunctions", "", "", "excludedFunctions", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "ignoreActualFunction", "", "ignoreOverridableFunction", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkActualFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkContainingInterface", "checkOverridableFunction", "isConstantExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNotExcluded", "isNotIgnored", "isReturningAConstant", "returnsConstant", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "Companion", "detekt-rules-style"})
public final class FunctionOnlyReturningConstant
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean ignoreOverridableFunction;
    private final boolean ignoreActualFunction;
    private final SplitPattern excludedFunctions;
    private final List<String> excludeAnnotatedFunctions;
    private AnnotationExcluder annotationExcluder;
    @NotNull
    public static final String IGNORE_OVERRIDABLE_FUNCTION = "ignoreOverridableFunction";
    @NotNull
    public static final String IGNORE_ACTUAL_FUNCTION = "ignoreActualFunction";
    @NotNull
    public static final String EXCLUDED_FUNCTIONS = "excludedFunctions";
    @NotNull
    public static final String EXCLUDE_ANNOTATED_FUNCTION = "excludeAnnotatedFunction";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.annotationExcluder = new AnnotationExcluder(root, this.excludeAnnotatedFunctions);
        super.visit(root);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.isNotIgnored(function) && this.isNotExcluded(function) && this.isReturningAConstant(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), function.getNameAsSafeName() + " is returning a constant. Prefer declaring a constant instead.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isNotIgnored(KtNamedFunction function) {
        return this.checkOverridableFunction(function) && this.checkActualFunction(function);
    }

    private final boolean checkOverridableFunction(KtNamedFunction function) {
        return this.ignoreOverridableFunction ? !(KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) || KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)function)) || this.checkContainingInterface(function)) : true;
    }

    private final boolean checkContainingInterface(KtNamedFunction function) {
        KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)function));
        return containingClass != null && containingClass.isInterface();
    }

    private final boolean checkActualFunction(KtNamedFunction function) {
        return this.ignoreActualFunction ? !KtModifierListKt.isActual((KtModifierListOwner)((KtModifierListOwner)function)) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotExcluded(KtNamedFunction function) {
        if (this.excludedFunctions.contains(function.getName())) return false;
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
        }
        List list = function.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.annotationEntries");
        if (annotationExcluder.shouldExclude(list)) return false;
        return true;
    }

    private final boolean isReturningAConstant(KtNamedFunction function) {
        return this.isConstantExpression(function.getBodyExpression()) || this.returnsConstant(function);
    }

    private final boolean isConstantExpression(KtExpression expression) {
        if (expression instanceof KtConstantExpression) {
            return true;
        }
        return expression instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)expression).hasInterpolation();
    }

    private final boolean returnsConstant(KtNamedFunction function) {
        KtReturnExpression returnExpression;
        PsiElement psiElement;
        Object[] objectArray = function.getBodyExpression();
        if (!((objectArray != null && (objectArray = objectArray.getChildren()) != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : (psiElement = null)) instanceof KtReturnExpression)) {
            psiElement = null;
        }
        KtReturnExpression ktReturnExpression = returnExpression = (KtReturnExpression)psiElement;
        return this.isConstantExpression((KtExpression)(ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null));
    }

    /*
     * WARNING - void declaration
     */
    public FunctionOnlyReturningConstant(@NotNull Config config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A function that only returns a constant is misleading. Consider declaring a constant instead", Debt.Companion.getTEN_MINS());
        this.ignoreOverridableFunction = (Boolean)this.valueOrDefault(IGNORE_OVERRIDABLE_FUNCTION, true);
        this.ignoreActualFunction = (Boolean)this.valueOrDefault(IGNORE_ACTUAL_FUNCTION, true);
        this.excludedFunctions = new SplitPattern((String)this.valueOrDefault(EXCLUDED_FUNCTIONS, "describeContents"), null, false, 6, null);
        Iterable iterable = PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)EXCLUDE_ANNOTATED_FUNCTION, (List)CollectionsKt.listOf((Object)"dagger.Provides"));
        FunctionOnlyReturningConstant functionOnlyReturningConstant = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*");
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        functionOnlyReturningConstant.excludeAnnotatedFunctions = collection;
    }

    public /* synthetic */ FunctionOnlyReturningConstant(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public FunctionOnlyReturningConstant() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant$Companion;", "", "()V", "EXCLUDED_FUNCTIONS", "", "EXCLUDE_ANNOTATED_FUNCTION", "IGNORE_ACTUAL_FUNCTION", "IGNORE_OVERRIDABLE_FUNCTION", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

