/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\f\u0010#\u001a\u00020\u0015*\u00020\"H\u0002J\f\u0010$\u001a\u00020\u0015*\u00020\"H\u0002J\f\u0010%\u001a\u00020\u0015*\u00020\u0017H\u0002J\f\u0010&\u001a\u00020\u0015*\u00020\"H\u0002J\f\u0010'\u001a\u00020\u0015*\u00020\"H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006j\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006j\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MayBeConst;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "binaryTokens", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Lkotlin/collections/HashSet;", "companionObjectConstants", "", "defaultRuleIdAliases", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "topLevelConstants", "isBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isParenthesizedExpression", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "canBeConst", "cannotBeConstant", "isConstantExpression", "isInObject", "isJvmField", "detekt-rules-style"})
public final class MayBeConst
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    private final HashSet<KtSingleValueToken> binaryTokens;
    private final HashSet<String> topLevelConstants;
    private final HashSet<String> companionObjectConstants;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.topLevelConstants.clear();
        Iterable $this$filterIsInstance$iv = file.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl = false;
            if (!(it.isTopLevel() && KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List topLevelProperties = (List)destination$iv$iv;
        this.topLevelConstants.addAll(topLevelProperties);
        super.visitKtFile(file);
    }

    /*
     * WARNING - void declaration
     */
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isObjectLiteral()) {
            return;
        }
        Iterable $this$filterIsInstance$iv = declaration.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl = false;
            if (!KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtProperty it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List constProperties = (List)destination$iv$iv;
        this.companionObjectConstants.addAll(constProperties);
        super.visitObjectDeclaration(declaration);
        this.companionObjectConstants.removeAll(constProperties);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        if (this.canBeConst(property)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), property.getNameAsSafeName() + " can be a `const val`.", null, null, 24, null));
        }
    }

    private final boolean canBeConst(KtProperty $this$canBeConst) {
        if (this.cannotBeConstant($this$canBeConst) || this.isInObject($this$canBeConst) || this.isJvmField($this$canBeConst)) {
            return false;
        }
        KtExpression ktExpression = $this$canBeConst.getInitializer();
        return ktExpression != null && this.isConstantExpression(ktExpression);
    }

    private final boolean isJvmField(KtProperty $this$isJvmField) {
        boolean bl;
        block3: {
            List list = $this$isJvmField.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntries");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    KtAnnotationEntry ktAnnotationEntry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                    if (!Intrinsics.areEqual((Object)ktAnnotationEntry.getText(), (Object)"@JvmField")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isJvmField = bl;
        List list = $this$isJvmField.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntries");
        Collection collection = list;
        boolean bl3 = false;
        return !collection.isEmpty() && !isJvmField;
    }

    private final boolean cannotBeConstant(KtProperty $this$cannotBeConstant) {
        return $this$cannotBeConstant.isLocal() || $this$cannotBeConstant.isVar() || $this$cannotBeConstant.getGetter() != null || KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)$this$cannotBeConstant)) || KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)$this$cannotBeConstant));
    }

    private final boolean isInObject(KtProperty $this$isInObject) {
        return !$this$isInObject.isTopLevel() && !(KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isInObject)) instanceof KtObjectDeclaration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConstantExpression(KtExpression $this$isConstantExpression) {
        if ($this$isConstantExpression instanceof KtStringTemplateExpression) {
            if (!((KtStringTemplateExpression)$this$isConstantExpression).hasInterpolation()) return true;
        }
        ASTNode aSTNode = $this$isConstantExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.BOOLEAN_CONSTANT)) return true;
        ASTNode aSTNode2 = $this$isConstantExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node");
        if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)KtNodeTypes.INTEGER_CONSTANT)) return true;
        ASTNode aSTNode3 = $this$isConstantExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node");
        if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)KtNodeTypes.CHARACTER_CONSTANT)) return true;
        ASTNode aSTNode4 = $this$isConstantExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node");
        if (Intrinsics.areEqual((Object)aSTNode4.getElementType(), (Object)KtNodeTypes.FLOAT_CONSTANT)) return true;
        if (this.topLevelConstants.contains($this$isConstantExpression.getText())) return true;
        if (this.companionObjectConstants.contains($this$isConstantExpression.getText())) return true;
        if (this.isBinaryExpression($this$isConstantExpression)) return true;
        if (!this.isParenthesizedExpression($this$isConstantExpression)) return false;
        return true;
    }

    private final boolean isParenthesizedExpression(KtExpression expression) {
        KtParenthesizedExpression ktParenthesizedExpression;
        KtExpression ktExpression = expression;
        if (!(ktExpression instanceof KtParenthesizedExpression)) {
            ktExpression = null;
        }
        return (ktParenthesizedExpression = (KtParenthesizedExpression)ktExpression) != null && (ktParenthesizedExpression = ktParenthesizedExpression.getExpression()) != null && this.isConstantExpression((KtExpression)ktParenthesizedExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBinaryExpression(KtExpression expression) {
        if (!(expression instanceof KtBinaryExpression)) return false;
        ASTNode aSTNode = ((KtBinaryExpression)expression).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"expression.node");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) return false;
        if (!CollectionsKt.contains((Iterable)this.binaryTokens, (Object)((KtBinaryExpression)expression).getOperationToken())) return false;
        KtExpression ktExpression = ((KtBinaryExpression)expression).getLeft();
        if (ktExpression == null) return false;
        if (!this.isConstantExpression(ktExpression)) return false;
        KtExpression ktExpression2 = ((KtBinaryExpression)expression).getRight();
        if (ktExpression2 == null) return false;
        if (!this.isConstantExpression(ktExpression2)) return false;
        return true;
    }

    public MayBeConst(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Reports vals that can be const val instead.", Debt.Companion.getFIVE_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"MayBeConstant");
        Object[] objectArray = new KtSingleValueToken[5];
        KtSingleValueToken ktSingleValueToken = KtTokens.PLUS;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.PLUS");
        objectArray[0] = ktSingleValueToken;
        KtSingleValueToken ktSingleValueToken2 = KtTokens.MINUS;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"KtTokens.MINUS");
        objectArray[1] = ktSingleValueToken2;
        KtSingleValueToken ktSingleValueToken3 = KtTokens.MUL;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken3, (String)"KtTokens.MUL");
        objectArray[2] = ktSingleValueToken3;
        KtSingleValueToken ktSingleValueToken4 = KtTokens.DIV;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken4, (String)"KtTokens.DIV");
        objectArray[3] = ktSingleValueToken4;
        KtSingleValueToken ktSingleValueToken5 = KtTokens.PERC;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken5, (String)"KtTokens.PERC");
        objectArray[4] = ktSingleValueToken5;
        this.binaryTokens = SetsKt.hashSetOf((Object[])objectArray);
        this.topLevelConstants = new HashSet();
        this.companionObjectConstants = new HashSet();
    }

    public /* synthetic */ MayBeConst(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MayBeConst() {
        this(null, 1, null);
    }
}

