/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.rules.GuardClausesKt;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$countReturnStatements$;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$isNamedReturnFromLambda$;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeGuardClauses", "", "excludeLabeled", "excludeLambdas", "excludedFunctions", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "countReturnStatements", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeIgnored", "visitNamedFunction", "", "isNamedReturnFromLambda", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Companion", "detekt-rules-style"})
public final class ReturnCount
extends Rule {
    @NotNull
    private final Issue issue;
    private final int max;
    private final SplitPattern excludedFunctions;
    private final boolean excludeLabeled;
    private final boolean excludeLambdas;
    private final boolean excludeGuardClauses;
    @NotNull
    public static final String MAX = "max";
    @NotNull
    public static final String EXCLUDED_FUNCTIONS = "excludedFunctions";
    @NotNull
    public static final String EXCLUDE_LABELED = "excludeLabeled";
    @NotNull
    public static final String EXCLUDE_RETURN_FROM_LAMBDA = "excludeReturnFromLambda";
    @NotNull
    public static final String EXCLUDE_GUARD_CLAUSES = "excludeGuardClauses";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        int numberOfReturns;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (!this.shouldBeIgnored(function) && (numberOfReturns = this.countReturnStatements(function)) > this.max) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "Function " + function.getName() + " has " + numberOfReturns + " return statements " + "which exceeds the limit of " + this.max + '.', null, null, 24, null));
        }
    }

    private final boolean shouldBeIgnored(KtNamedFunction function) {
        return this.excludedFunctions.contains(function.getName());
    }

    private final int countReturnStatements(KtNamedFunction function) {
        Object object;
        Function1<KtReturnExpression, Boolean> $fun$isExcluded$1 = new Function1<KtReturnExpression, Boolean>(this){
            final /* synthetic */ ReturnCount this$0;

            public final boolean invoke(@NotNull KtReturnExpression $this$isExcluded) {
                Intrinsics.checkNotNullParameter((Object)$this$isExcluded, (String)"$this$isExcluded");
                return ReturnCount.access$getExcludeLabeled$p(this.this$0) && $this$isExcluded.getLabeledExpression() != null ? true : ReturnCount.access$getExcludeLambdas$p(this.this$0) && ReturnCount.access$isNamedReturnFromLambda(this.this$0, $this$isExcluded);
            }
            {
                this.this$0 = returnCount;
                super(1);
            }
        };
        if (this.excludeGuardClauses) {
            KtNamedFunction $this$yieldStatementsSkippingGuardClauses$iv = function;
            boolean $i$f$yieldStatementsSkippingGuardClauses = false;
            object = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object>($this$yieldStatementsSkippingGuardClauses$iv, null){
                private /* synthetic */ Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ KtNamedFunction $this_yieldStatementsSkippingGuardClauses;
                {
                    this.$this_yieldStatementsSkippingGuardClauses = ktNamedFunction;
                    super(2, continuation);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            var4_4 = new Ref.BooleanRef();
                            var4_4.element = false;
                            v0 /* !! */  = this.$this_yieldStatementsSkippingGuardClauses.getBodyBlockExpression();
                            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getStatements()) == null) break;
                            $this$forEach$iv = (Iterable)v0 /* !! */ ;
                            $i$f$forEach = false;
                            var7_7 = $this$forEach$iv.iterator();
lbl13:
                            // 6 sources

                            while (var7_7.hasNext()) {
                                element$iv = var7_7.next();
                                it = (KtExpression)element$iv;
                                $i$a$-forEach-GuardClausesKt$yieldStatementsSkippingGuardClauses$1$1 = false;
                                if (!firstNonGuardFound.element) break block0;
                                this.L$0 = $this$sequence;
                                this.L$1 = firstNonGuardFound;
                                this.L$2 = var7_7;
                                this.label = 1;
                                v1 = $this$sequence.yield((Object)it, (Continuation)this);
                                if (v1 != var2_2) continue;
                                var11_20 = var2_2;
                                return var11_20;
                            }
                            break;
                        }
                        case 1: {
                            $i$f$forEach = false;
                            $i$a$-forEach-GuardClausesKt$yieldStatementsSkippingGuardClauses$1$1 = false;
                            var7_7 = (Iterator<T>)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl13
                        }
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    $i$f$isGuardClause = false;
                    $this$findDescendantOfType_u24default$iv$iv = (PsiElement)$this$isGuardClause$iv;
                    predicate$iv$iv = countReturnStatements$$inlined$yieldStatementsSkippingGuardClauses$1$1.INSTANCE;
                    $i$f$findDescendantOfType = false;
                    $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType_u24default$iv$iv;
                    $i$f$findDescendantOfType = false;
                    result$iv$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv, result$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                this.$result.element = element;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                        }
                    });
                    if ((KtExpression)((PsiElement)result$iv$iv$iv.element) == null ? false : GuardClausesKt.isIfConditionGuardClause((KtExpression)$this$isGuardClause$iv, (KtExpression)descendantExpr$iv) != false || GuardClausesKt.isElvisOperatorGuardClause((KtExpression)$this$isGuardClause$iv) != false) ** GOTO lbl13
                    firstNonGuardFound.element = true;
                    this.L$0 = $this$sequence;
                    this.L$1 = firstNonGuardFound;
                    this.L$2 = var7_7;
                    this.label = 2;
                    v2 = $this$sequence.yield((Object)it, (Continuation)this);
                    if (v2 != var2_2) ** GOTO lbl13
                    var11_21 = var2_2;
                    return var11_21;
                    {
                        case 2: {
                            $i$f$forEach = false;
                            $i$a$-forEach-GuardClausesKt$yieldStatementsSkippingGuardClauses$1$1 = false;
                            var7_7 = (Iterator)this.L$2;
                            firstNonGuardFound = (Ref.BooleanRef)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl13
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    Function2<SequenceScope<? super KtExpression>, Continuation<? super Unit>, Object> function22 = function2;
                    return function22;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            object = function.getBodyBlockExpression();
            if (object == null || (object = object.getStatements()) == null || (object = CollectionsKt.asSequence((Iterable)((Iterable)object))) == null) {
                object = SequencesKt.emptySequence();
            }
        }
        Object statements = object;
        return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)statements, (Function1)countReturnStatements.2.INSTANCE), (Function1)((Function1)new Function1<KtReturnExpression, Boolean>($fun$isExcluded$1){
            final /* synthetic */ countReturnStatements.1 $isExcluded$1;

            public final boolean invoke(@NotNull KtReturnExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$isExcluded$1.invoke(it);
            }
            {
                this.$isExcluded$1 = var1_1;
                super(1);
            }
        })), (Function1)((Function1)new Function1<KtReturnExpression, Boolean>(function){
            final /* synthetic */ KtNamedFunction $function;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull KtReturnExpression it) {
                void $this$getParentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiElement psiElement = (PsiElement)it;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                return Intrinsics.areEqual((Object)((KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv)), (Object)this.$function);
            }
            {
                this.$function = ktNamedFunction;
                super(1);
            }
        })));
    }

    private final boolean isNamedReturnFromLambda(KtReturnExpression $this$isNamedReturnFromLambda) {
        PsiElement label = $this$isNamedReturnFromLambda.getLabeledExpression();
        if (label != null) {
            boolean bl;
            block3: {
                KtElement $this$parentsOfTypeUntil$iv = (KtElement)$this$isNamedReturnFromLambda;
                boolean strict$iv = true;
                boolean $i$f$parentsOfTypeUntil = false;
                Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object>($this$parentsOfTypeUntil$iv, strict$iv, null){
                    private /* synthetic */ Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ KtElement $this_parentsOfTypeUntil;
                    final /* synthetic */ boolean $strict;
                    {
                        this.$this_parentsOfTypeUntil = ktElement;
                        this.$strict = bl;
                        super(2, continuation);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                v0 = current = this.$strict != false ? this.$this_parentsOfTypeUntil.getParent() : (PsiElement)this.$this_parentsOfTypeUntil;
lbl7:
                                // 2 sources

                                while (current != null && !(current instanceof KtNamedFunction)) {
                                    if (current instanceof KtCallExpression) {
                                        this.L$0 = $this$sequence;
                                        this.L$1 = current;
                                        this.label = 1;
                                        v1 = $this$sequence.yield((Object)current, (Continuation)this);
                                        if (v1 == var2_2) {
                                            var5_5 = var2_2;
                                            return var5_5;
                                        }
                                    }
                                    ** GOTO lbl23
                                }
                                break;
                            }
                            case 1: {
                                current = (PsiElement)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                current = current.getParent();
                                ** GOTO lbl7
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function1)isNamedReturnFromLambda.1.INSTANCE);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isNamedReturnFromLambda$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$any$iv = SequencesKt.map((Sequence)sequence, (Function1)isNamedReturnFromLambda.2.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = label.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label.text");
                    CharSequence charSequence = string;
                    String string2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public ReturnCount(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Restrict the number of return statements in methods.", Debt.Companion.getTEN_MINS());
        this.max = ((Number)this.valueOrDefault(MAX, 2)).intValue();
        this.excludedFunctions = new SplitPattern((String)this.valueOrDefault(EXCLUDED_FUNCTIONS, "equals"), null, false, 6, null);
        this.excludeLabeled = (Boolean)this.valueOrDefault(EXCLUDE_LABELED, false);
        this.excludeLambdas = (Boolean)this.valueOrDefault(EXCLUDE_RETURN_FROM_LAMBDA, true);
        this.excludeGuardClauses = (Boolean)this.valueOrDefault(EXCLUDE_GUARD_CLAUSES, false);
    }

    public /* synthetic */ ReturnCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ReturnCount() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getExcludeLabeled$p(ReturnCount $this) {
        return $this.excludeLabeled;
    }

    public static final /* synthetic */ boolean access$getExcludeLambdas$p(ReturnCount $this) {
        return $this.excludeLambdas;
    }

    public static final /* synthetic */ boolean access$isNamedReturnFromLambda(ReturnCount $this, KtReturnExpression $this$access_u24isNamedReturnFromLambda) {
        return $this.isNamedReturnFromLambda($this$access_u24isNamedReturnFromLambda);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount$Companion;", "", "()V", "EXCLUDED_FUNCTIONS", "", "EXCLUDE_GUARD_CLAUSES", "EXCLUDE_LABELED", "EXCLUDE_RETURN_FROM_LAMBDA", "MAX", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

