/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0013\u001a\u00020\n*\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\n*\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"firstLambdaArg", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getFirstLambdaArg", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "firstParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getFirstParameter", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)Lorg/jetbrains/kotlin/psi/KtParameter;", "canBeReplacedWithCall", "", "lambdaExpr", "countReferences", "", "countVarRefs", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "varName", "", "lambda", "hasOnlyOneStatement", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isLetExpr", "detekt-rules-style"})
public final class UnnecessaryLetKt {
    private static final boolean canBeReplacedWithCall(KtLambdaExpression lambdaExpr) {
        boolean bl;
        block10: {
            KtBlockExpression lambdaBody;
            KtLambdaExpression ktLambdaExpression = lambdaExpr;
            KtParameter lambdaParameter = ktLambdaExpression != null ? UnnecessaryLetKt.getFirstParameter(ktLambdaExpression) : null;
            KtLambdaExpression ktLambdaExpression2 = lambdaExpr;
            KtBlockExpression ktBlockExpression = lambdaBody = ktLambdaExpression2 != null ? ktLambdaExpression2.getBodyExpression() : null;
            if (ktBlockExpression == null || !UnnecessaryLetKt.hasOnlyOneStatement(ktBlockExpression)) {
                return false;
            }
            PsiElement firstExpr = lambdaBody.getFirstChild();
            KtExpression exprReceiver = firstExpr instanceof KtDotQualifiedExpression ? ((KtDotQualifiedExpression)firstExpr).getReceiverExpression() : (firstExpr instanceof KtSafeQualifiedExpression ? ((KtSafeQualifiedExpression)firstExpr).getReceiverExpression() : null);
            if (exprReceiver == null) {
                bl = false;
            } else if (lambdaParameter == null) {
                bl = exprReceiver.textMatches((CharSequence)"it");
            } else {
                KtDestructuringDeclaration destructuringDeclaration = lambdaParameter.getDestructuringDeclaration();
                Object object = destructuringDeclaration;
                if (object != null && (object = object.getEntries()) != null) {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv;
                            boolean bl2 = false;
                            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"it");
                            if (!exprReceiver.textMatches((CharSequence)ktDestructuringDeclarationEntry.getNameAsSafeName().asString())) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = exprReceiver.textMatches((CharSequence)lambdaParameter.getNameAsSafeName().asString());
                }
            }
        }
        return bl;
    }

    private static final boolean isLetExpr(KtCallExpression $this$isLetExpr) {
        KtExpression ktExpression = $this$isLetExpr.getCalleeExpression();
        return ktExpression != null && ktExpression.textMatches((CharSequence)"let");
    }

    private static final KtLambdaExpression getFirstLambdaArg(KtCallExpression $this$firstLambdaArg) {
        List list = $this$firstLambdaArg.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
        return ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
    }

    private static final KtParameter getFirstParameter(KtLambdaExpression $this$firstParameter) {
        List list = $this$firstParameter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueParameters");
        return (KtParameter)CollectionsKt.firstOrNull((List)list);
    }

    private static final boolean hasOnlyOneStatement(KtBlockExpression $this$hasOnlyOneStatement) {
        return $this$hasOnlyOneStatement.getChildren().length == 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int countVarRefs(PsiElement $this$countVarRefs, String varName, KtLambdaExpression lambda) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Object object = $this$countVarRefs;
        Function1 predicate$iv = (Function1)new Function1<KtSimpleNameExpression, Boolean>(lambda, varName){
            final /* synthetic */ KtLambdaExpression $lambda;
            final /* synthetic */ String $varName;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull KtSimpleNameExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!it.textMatches((CharSequence)this.$varName)) return false;
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)it;
                boolean $i$f$getStrictParentOfType = false;
                if (!Intrinsics.areEqual((Object)((KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLambdaExpression.class, (boolean)true)), (Object)this.$lambda)) return false;
                return true;
            }
            {
                this.$lambda = ktLambdaExpression;
                this.$varName = string;
                super(1);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var8_9 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var11_12 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtSimpleNameExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtSimpleNameExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        object = (List)to$iv$iv$iv;
        boolean bl = false;
        return object.size();
    }

    /*
     * WARNING - void declaration
     */
    private static final int countReferences(KtLambdaExpression $this$countReferences) {
        int n;
        KtDestructuringDeclaration destructuringDeclaration;
        KtBlockExpression ktBlockExpression = $this$countReferences.getBodyExpression();
        if (ktBlockExpression == null) {
            return 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"bodyExpression ?: return 0");
        KtBlockExpression bodyExpression = ktBlockExpression;
        KtParameter ktParameter = UnnecessaryLetKt.getFirstParameter($this$countReferences);
        Object object = destructuringDeclaration = ktParameter != null ? ktParameter.getDestructuringDeclaration() : null;
        if (destructuringDeclaration != null) {
            List list = destructuringDeclaration.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"destructuringDeclaration.entries");
            Iterable $this$sumBy$iv = list;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = (KtDestructuringDeclarationEntry)element$iv;
                int n2 = sum$iv;
                boolean bl = false;
                PsiElement psiElement = (PsiElement)bodyExpression;
                void v5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                String string = v5.getNameAsSafeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.nameAsSafeName.asString()");
                int n3 = UnnecessaryLetKt.countVarRefs(psiElement, string, $this$countReferences);
                sum$iv = n2 + n3;
            }
            n = sum$iv;
        } else {
            Object object2 = UnnecessaryLetKt.getFirstParameter($this$countReferences);
            if (object2 == null || (object2 = object2.getNameAsSafeName()) == null || (object2 = object2.asString()) == null) {
                object2 = "it";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"firstParameter?.nameAsSa\u2026.asString() ?: IT_LITERAL");
            Object parameterName = object2;
            n = UnnecessaryLetKt.countVarRefs((PsiElement)bodyExpression, (String)parameterName, $this$countReferences);
        }
        return n;
    }

    public static final /* synthetic */ boolean access$isLetExpr(KtCallExpression $this$access_u24isLetExpr) {
        return UnnecessaryLetKt.isLetExpr($this$access_u24isLetExpr);
    }

    public static final /* synthetic */ KtLambdaExpression access$getFirstLambdaArg$p(KtCallExpression $this$access_u24firstLambdaArg_u24p) {
        return UnnecessaryLetKt.getFirstLambdaArg($this$access_u24firstLambdaArg_u24p);
    }

    public static final /* synthetic */ int access$countReferences(KtLambdaExpression $this$access_u24countReferences) {
        return UnnecessaryLetKt.countReferences($this$access_u24countReferences);
    }

    public static final /* synthetic */ boolean access$canBeReplacedWithCall(KtLambdaExpression lambdaExpr) {
        return UnnecessaryLetKt.canBeReplacedWithCall(lambdaExpr);
    }
}

