/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u0011*\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\u000fH\u0002J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u000fH\u0002J\u000e\u0010\u0017\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\f\u0010\u0019\u001a\u00020\u0011*\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000f*\u00020\fH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u001fH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isCalling", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "fqNames", "", "isCollectionOrArray", "isCollectionOrArrayOrString", "isEmptyString", "isNullKeyword", "isString", "isZero", "nullCheckedExpression", "sizeCheckedEmptyString", "sizeCheckedEqualToZero", "sizeCheckedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Companion", "detekt-rules-style"})
public final class UseIsNullOrEmpty
extends Rule {
    @NotNull
    private final Issue issue;
    private static final List<FqName> collectionClasses;
    private static final FqName arrayClass;
    private static final FqName stringClass;
    private static final List<FqName> isEmptyFunctions;
    private static final List<FqName> countFunctions;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.OROR) ^ true) {
            return;
        }
        KtExpression ktExpression = expression.getLeft();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression left = ktBinaryExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.right ?: return");
        KtExpression right = ktExpression2;
        KtSimpleNameExpression ktSimpleNameExpression = this.nullCheckedExpression(left);
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression nullCheckedExpression = ktSimpleNameExpression;
        KtSimpleNameExpression ktSimpleNameExpression2 = this.sizeCheckedExpression(right);
        if (ktSimpleNameExpression2 == null) {
            return;
        }
        KtSimpleNameExpression sizeCheckedExpression = ktSimpleNameExpression2;
        if (Intrinsics.areEqual((Object)nullCheckedExpression.getText(), (Object)sizeCheckedExpression.getText()) ^ true) {
            return;
        }
        String message = "This '" + expression.getText() + "' can be replaced with 'isNullOrEmpty()' call";
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final KtSimpleNameExpression nullCheckedExpression(KtBinaryExpression $this$nullCheckedExpression) {
        Object object;
        if (Intrinsics.areEqual((Object)$this$nullCheckedExpression.getOperationToken(), (Object)KtTokens.EQEQ) ^ true) {
            return null;
        }
        KtExpression $this$safeAs$iv = this.isNullKeyword($this$nullCheckedExpression.getRight()) ? $this$nullCheckedExpression.getLeft() : (this.isNullKeyword($this$nullCheckedExpression.getLeft()) ? $this$nullCheckedExpression.getRight() : null);
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression != null) {
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)it), (BindingContext)this.getBindingContext());
            object = kotlinType != null && KotlinTypeKt.isNullable((KotlinType)kotlinType) ? ktSimpleNameExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression = $this$sizeCheckedExpression;
        return ktExpression instanceof KtDotQualifiedExpression ? this.sizeCheckedExpression((KtDotQualifiedExpression)$this$sizeCheckedExpression) : (ktExpression instanceof KtBinaryExpression ? this.sizeCheckedExpression((KtBinaryExpression)$this$sizeCheckedExpression) : null);
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtDotQualifiedExpression $this$sizeCheckedExpression) {
        Object object;
        if (!this.isCalling($this$sizeCheckedExpression.getSelectorExpression(), isEmptyFunctions)) {
            return null;
        }
        KtExpression $this$safeAs$iv = $this$sizeCheckedExpression.getReceiverExpression();
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression != null) {
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            object = this.isCollectionOrArrayOrString(it) ? ktSimpleNameExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtBinaryExpression $this$sizeCheckedExpression) {
        Object object;
        if (Intrinsics.areEqual((Object)$this$sizeCheckedExpression.getOperationToken(), (Object)KtTokens.EQEQ) ^ true) {
            return null;
        }
        if (this.isEmptyString($this$sizeCheckedExpression.getRight())) {
            KtExpression ktExpression = $this$sizeCheckedExpression.getLeft();
            object = ktExpression != null ? this.sizeCheckedEmptyString(ktExpression) : null;
        } else if (this.isEmptyString($this$sizeCheckedExpression.getLeft())) {
            KtExpression ktExpression = $this$sizeCheckedExpression.getRight();
            object = ktExpression != null ? this.sizeCheckedEmptyString(ktExpression) : null;
        } else if (this.isZero($this$sizeCheckedExpression.getRight())) {
            KtExpression ktExpression = $this$sizeCheckedExpression.getLeft();
            object = ktExpression != null ? this.sizeCheckedEqualToZero(ktExpression) : null;
        } else if (this.isZero($this$sizeCheckedExpression.getLeft())) {
            KtExpression ktExpression = $this$sizeCheckedExpression.getRight();
            object = ktExpression != null ? this.sizeCheckedEqualToZero(ktExpression) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedEmptyString(KtExpression $this$sizeCheckedEmptyString) {
        Object object;
        KtExpression $this$safeAs$iv = $this$sizeCheckedEmptyString;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression != null) {
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            object = this.isString(it) ? ktSimpleNameExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedEqualToZero(KtExpression $this$sizeCheckedEqualToZero) {
        if (!($this$sizeCheckedEqualToZero instanceof KtDotQualifiedExpression)) {
            return null;
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getReceiverExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return null;
        }
        KtSimpleNameExpression receiver = ktSimpleNameExpression;
        KtExpression ktExpression2 = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getSelectorExpression();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression selector = ktExpression2;
        if (selector instanceof KtCallExpression ? !this.isCollectionOrArrayOrString(receiver) || !this.isCalling(selector, countFunctions) : (Intrinsics.areEqual((Object)selector.getText(), (Object)"size") ? !this.isCollectionOrArray(receiver) : Intrinsics.areEqual((Object)selector.getText(), (Object)"length") && !this.isString(receiver))) {
            return null;
        }
        return receiver;
    }

    private final boolean isNullKeyword(KtExpression $this$isNullKeyword) {
        KtExpression ktExpression = $this$isNullKeyword;
        String string = ktExpression != null ? ktExpression.getText() : null;
        KtKeywordToken ktKeywordToken = KtTokens.NULL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NULL_KEYWORD");
        return Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue());
    }

    private final boolean isZero(KtExpression $this$isZero) {
        KtExpression ktExpression = $this$isZero;
        return Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"0");
    }

    private final boolean isEmptyString(KtExpression $this$isEmptyString) {
        KtExpression ktExpression = $this$isEmptyString;
        return Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"\"\"");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        ResolvedCall resolvedCall;
        void $this$mapTo$iv$iv;
        KtCallExpression ktCallExpression;
        KtExpression $this$safeAs$iv = $this$isCalling;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        if ((ktCallExpression = (KtCallExpression)ktExpression) == null) {
            $this$safeAs$iv = $this$isCalling;
            $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
                ktExpression2 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
            $this$safeAs$iv = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
            $i$f$safeAs = false;
            KtExpression ktExpression3 = $this$safeAs$iv;
            if (!(ktExpression3 instanceof KtCallExpression)) {
                ktExpression3 = null;
            }
            ktCallExpression = (KtCallExpression)ktExpression3;
        }
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        Iterable $this$map$iv = fqNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.shortName().asString();
            collection.add(string);
        }
        KtExpression ktExpression4 = callExpression.getCalleeExpression();
        return CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)(ktExpression4 != null ? ktExpression4.getText() : null)) && CollectionsKt.contains((Iterable)fqNames, (resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression), (BindingContext)this.getBindingContext())) != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall)) : null);
    }

    private final FqName classFqName(KtSimpleNameExpression $this$classFqName) {
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)$this$classFqName), (BindingContext)this.getBindingContext());
        return kotlinType != null ? TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType) : null;
    }

    private final boolean isCollectionOrArrayOrString(KtSimpleNameExpression $this$isCollectionOrArrayOrString) {
        FqName fqName = this.classFqName($this$isCollectionOrArrayOrString);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, (Object)this.classFqName($this$isCollectionOrArrayOrString)) || Intrinsics.areEqual((Object)classFqName, (Object)arrayClass) || Intrinsics.areEqual((Object)classFqName, (Object)stringClass);
    }

    private final boolean isCollectionOrArray(KtSimpleNameExpression $this$isCollectionOrArray) {
        FqName fqName = this.classFqName($this$isCollectionOrArray);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, (Object)this.classFqName($this$isCollectionOrArray)) || Intrinsics.areEqual((Object)classFqName, (Object)arrayClass);
    }

    private final boolean isString(KtSimpleNameExpression $this$isString) {
        return Intrinsics.areEqual((Object)this.classFqName($this$isString), (Object)stringClass);
    }

    public UseIsNullOrEmpty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseIsNullOrEmpty", Severity.Style, "Use 'isNullOrEmpty()' call instead of 'x == null || x.isEmpty()'", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseIsNullOrEmpty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UseIsNullOrEmpty() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String p1;
        Object object;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Companion = new Companion(null);
        collectionClasses = CollectionsKt.listOf((Object[])new FqName[]{StandardNames.FqNames.list, StandardNames.FqNames.set, StandardNames.FqNames.collection, StandardNames.FqNames.map, StandardNames.FqNames.mutableList, StandardNames.FqNames.mutableSet, StandardNames.FqNames.mutableCollection, StandardNames.FqNames.mutableMap});
        FqName fqName = StandardNames.FqNames.array.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"StandardNames.FqNames.array.toSafe()");
        arrayClass = fqName;
        FqName fqName2 = StandardNames.FqNames.string.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"StandardNames.FqNames.string.toSafe()");
        stringClass = fqName2;
        Iterable $this$map$iv = collectionClasses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FqName fqName3 = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new FqName(it + ".isEmpty");
            collection.add(object);
        }
        $this$map$iv = CollectionsKt.listOf((Object[])new String[]{"kotlin.collections.isEmpty", "kotlin.text.isEmpty"});
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            FqName fqName4 = new FqName(p1);
            object.add(fqName4);
        }
        object = (List)destination$iv$iv;
        isEmptyFunctions = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $this$map$iv = CollectionsKt.listOf((Object[])new String[]{"kotlin.collections.count", "kotlin.text.count"});
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p1 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new FqName(p1);
            collection.add(object);
        }
        countFunctions = (List)var3_3;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty$Companion;", "", "()V", "arrayClass", "Lorg/jetbrains/kotlin/name/FqName;", "collectionClasses", "", "countFunctions", "isEmptyFunctions", "stringClass", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

