/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0015\u001a\u00020\u000f*\u0004\u0018\u00010\u0016H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ktAndJavaCollections", "", "", "ktCollections", "mapAccessMethods", "isGetOrPut", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isMapMethod", "visitCallExpression", "", "isEligibleCollection", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-style"})
public final class ExplicitCollectionElementAccessMethod
extends Rule {
    @NotNull
    private final Set<String> ktCollections;
    @NotNull
    private final Set<String> mapAccessMethods;
    @NotNull
    private final Set<String> ktAndJavaCollections;
    @NotNull
    private final Issue issue;

    public ExplicitCollectionElementAccessMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        Object[] objectArray = new String[]{"kotlin.collections.Map", "kotlin.collections.MutableMap", "kotlin.collections.List", "kotlin.collections.MutableList"};
        this.ktCollections = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"get", "put"};
        this.mapAccessMethods = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"AbstractMap", "AbstractList"};
        this.ktAndJavaCollections = SetsKt.plus(this.ktCollections, (Iterable)SetsKt.setOf((Object[])objectArray));
        this.issue = new Issue("ExplicitCollectionElementAccessMethod", Severity.Style, "Prefer usage of indexed access operator [] for map element access or insert methods", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ExplicitCollectionElementAccessMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isMapMethod(expression) && this.isGetOrPut(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Prefer usage of indexed access operator [].", null, null, 24, null));
        }
        super.visitCallExpression(expression);
    }

    private final boolean isGetOrPut(KtCallExpression expression) {
        KtExpression ktExpression = expression.getCalleeExpression();
        return CollectionsKt.contains((Iterable)this.mapAccessMethods, (Object)(ktExpression == null ? null : ktExpression.getText()));
    }

    private final boolean isMapMethod(KtCallExpression expression) {
        PsiElement psiElement;
        PsiElement dotExpression = expression.getPrevSibling();
        PsiElement psiElement2 = dotExpression;
        PsiElement psiElement3 = psiElement = psiElement2 == null ? null : psiElement2.getParent();
        if (!(psiElement instanceof KtDotQualifiedExpression)) {
            return false;
        }
        PsiElement caller = dotExpression.getPrevSibling();
        psiElement = CallUtilKt.getResolvedCall((KtElement)(caller instanceof KtElement ? (KtElement)caller : null), (BindingContext)this.getBindingContext());
        return this.isEligibleCollection(psiElement == null ? null : ((psiElement2 = psiElement.getResultingDescriptor()) == null ? null : psiElement2.getReturnType()));
    }

    private final boolean isEligibleCollection(KotlinType $this$isEligibleCollection) {
        boolean bl;
        Object object;
        KotlinType kotlinType = $this$isEligibleCollection;
        if (CollectionsKt.contains((Iterable)this.ktCollections, kotlinType == null ? null : ((object = TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType)) == null ? null : object.asString()))) {
            return true;
        }
        kotlinType = $this$isEligibleCollection;
        if (kotlinType == null) {
            bl = false;
        } else {
            object = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes((KotlinType)kotlinType);
            if (object == null) {
                bl = false;
            } else {
                boolean bl2;
                block8: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl3 = false;
                            if (!this.ktAndJavaCollections.contains(it.getConstructor().toString())) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            }
        }
        return bl;
    }

    public ExplicitCollectionElementAccessMethod() {
        this(null, 1, null);
    }
}

