/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenPublicDataClass;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenPublicDataClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignorePackages", "", "Lkotlin/text/Regex;", "getIgnorePackages$annotations", "()V", "getIgnorePackages", "()Ljava/util/List;", "ignorePackages$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "detekt-rules-style"})
public final class ForbiddenPublicDataClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignorePackages$delegate;

    public ForbiddenPublicDataClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        Object[] objectArray = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"javaClass.simpleName");
        this.issue = new Issue((String)objectArray, Severity.Style, "The data classes are bad for the binary compatibility in public APIs. Avoid to use it.", Debt.Companion.getTWENTY_MINS());
        objectArray = new String[]{"*.internal", "*.internal.*"};
        this.ignorePackages$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), (Function1)ignorePackages.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenPublicDataClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getIgnorePackages() {
        return (List)this.ignorePackages$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores classes in the specified packages.")
    private static /* synthetic */ void getIgnorePackages$annotations() {
    }

    public void visitClass(@NotNull KtClass klass) {
        KtExpression ktExpression;
        String packageName;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        KtPackageDirective ktPackageDirective = klass.getContainingKtFile().getPackageDirective();
        String string = ktPackageDirective == null ? null : (packageName = (ktExpression = ktPackageDirective.getPackageNameExpression()) == null ? null : ktExpression.getText());
        if (packageName != null) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.getIgnorePackages();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!it.matches((CharSequence)packageName)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        ktExpression = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)klass));
        boolean bl = false;
        boolean bl3 = false;
        KtExpression visibility = ktExpression;
        boolean bl4 = false;
        boolean bl5 = !Intrinsics.areEqual((Object)visibility, (Object)KtTokens.INTERNAL_KEYWORD) && !Intrinsics.areEqual((Object)visibility, (Object)KtTokens.PRIVATE_KEYWORD);
        boolean isPublicOrProtected = bl5;
        if (isPublicOrProtected) {
            if (klass.isData()) {
                PsiElement psiElement = klass.getNameIdentifier();
                ktExpression = psiElement == null ? (PsiElement)klass : psiElement;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)ktExpression, (int)0, (int)2, null), "", null, null, 24, null));
            }
            super.visitClass(klass);
        }
    }

    public ForbiddenPublicDataClass() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ForbiddenPublicDataClass.class), "ignorePackages", "getIgnorePackages()Ljava/util/List;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

