/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IsPartOfUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NoTabs;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "findTabs", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectWhitespaces", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "isStringInterpolated", "", "isTab", "detekt-rules-style"})
public final class NoTabs
extends Rule {
    @NotNull
    private final Issue issue;

    public NoTabs(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Checks if tabs are used in Kotlin files.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NoTabs(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public final void findTabs(@NotNull KtFile file) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$filter$iv = this.collectWhitespaces(file);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiWhiteSpace it = (PsiWhiteSpace)element$iv$iv;
            boolean bl = false;
            if (!this.isTab(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), "Tab character is in use.", null, null, 24, null));
        }
    }

    private final List<PsiWhiteSpace> collectWhitespaces(KtFile $this$collectWhitespaces) {
        boolean bl = false;
        List list = new ArrayList();
        $this$collectWhitespaces.accept((PsiElementVisitor)new DetektVisitor(list){
            final /* synthetic */ List<PsiWhiteSpace> $list;
            {
                this.$list = $list;
            }

            public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
                this.$list.add(space);
                super.visitWhiteSpace(space);
            }
        });
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTab(PsiWhiteSpace $this$isTab) {
        if (IsPartOfUtilsKt.isPartOfString((PsiElement)((PsiElement)$this$isTab))) {
            if (!this.isStringInterpolated($this$isTab)) return false;
        }
        String string = $this$isTab.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.contains$default((CharSequence)string, (char)'\t', (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isStringInterpolated(PsiWhiteSpace $this$isStringInterpolated) {
        PsiElement $this$isPartOf$iv = (PsiElement)$this$isStringInterpolated;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtStringTemplateEntryWithExpression.class, (boolean)false) != null;
    }

    public NoTabs() {
        this(null, 1, null);
    }
}

