/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\n*\u00020\u0015H\u0002J\u0016\u0010\u001b\u001a\u00020\n*\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u0015H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ObjectLiteralToLambda;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "couldBeSamInterface", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getCouldBeSamInterface", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "visitObjectLiteralExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "containsMethodOf", "Lorg/jetbrains/kotlin/psi/KtExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "containsOwnMethodCall", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "containsThisReference", "hasConvertibleMethod", "isImplicitClassFor", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "singleNamedMethodOrNull", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "singleSuperTypeOrNull", "detekt-rules-style"})
public final class ObjectLiteralToLambda
extends Rule {
    @NotNull
    private final Issue issue;

    public ObjectLiteralToLambda(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Report object literals that can be changed to lambdas.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ObjectLiteralToLambda(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getCouldBeSamInterface(KotlinType $this$couldBeSamInterface) {
        ClassifierDescriptor classifierDescriptor = $this$couldBeSamInterface.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return !((ClassDescriptor)classifierDescriptor).isDefinitelyNotSamInterface();
    }

    private final KotlinType singleSuperTypeOrNull(KotlinType $this$singleSuperTypeOrNull) {
        Collection collection = $this$singleSuperTypeOrNull.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"constructor.supertypes");
        return (KotlinType)CollectionsKt.singleOrNull((Iterable)collection);
    }

    private final KtNamedFunction singleNamedMethodOrNull(KtObjectDeclaration $this$singleNamedMethodOrNull) {
        Object object = CollectionsKt.singleOrNull((List)$this$singleNamedMethodOrNull.getDeclarations());
        return object instanceof KtNamedFunction ? (KtNamedFunction)object : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsThisReference(KtExpression $this$containsThisReference, DeclarationDescriptor descriptor) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsThisReference;
        Function1 predicate$iv = (Function1)new Function1<KtThisExpression, Boolean>(this, descriptor){
            final /* synthetic */ ObjectLiteralToLambda this$0;
            final /* synthetic */ DeclarationDescriptor $descriptor;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                super(1);
            }

            public final boolean invoke(@NotNull KtThisExpression thisReference) {
                Intrinsics.checkNotNullParameter((Object)thisReference, (String)"thisReference");
                return Intrinsics.areEqual((Object)this.this$0.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)thisReference.getInstanceReference()), (Object)this.$descriptor);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtThisExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsOwnMethodCall(KtExpression $this$containsOwnMethodCall, DeclarationDescriptor descriptor) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsOwnMethodCall;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(this, descriptor){
            final /* synthetic */ ObjectLiteralToLambda this$0;
            final /* synthetic */ DeclarationDescriptor $descriptor;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                super(1);
            }

            public final boolean invoke(@NotNull KtExpression it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this.this$0.getBindingContext());
                if (resolvedCall == null) {
                    bl = false;
                } else {
                    ResolvedCall resolvedCall2 = resolvedCall;
                    ObjectLiteralToLambda objectLiteralToLambda = this.this$0;
                    DeclarationDescriptor declarationDescriptor = this.$descriptor;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ResolvedCall resolvedCall3 = resolvedCall2;
                    boolean bl4 = false;
                    bl = ObjectLiteralToLambda.access$isImplicitClassFor(objectLiteralToLambda, resolvedCall3.getDispatchReceiver(), declarationDescriptor) || ObjectLiteralToLambda.access$isImplicitClassFor(objectLiteralToLambda, resolvedCall3.getExtensionReceiver(), declarationDescriptor);
                }
                return bl;
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isImplicitClassFor(ReceiverValue $this$isImplicitClassFor, DeclarationDescriptor descriptor) {
        return $this$isImplicitClassFor instanceof ImplicitClassReceiver && Intrinsics.areEqual((Object)((ImplicitClassReceiver)$this$isImplicitClassFor).getClassDescriptor(), (Object)descriptor);
    }

    private final boolean containsMethodOf(KtExpression $this$containsMethodOf, KtObjectDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        DeclarationDescriptor objectDescriptor = declarationDescriptor2;
        return this.containsThisReference($this$containsMethodOf, objectDescriptor) || this.containsOwnMethodCall($this$containsMethodOf, objectDescriptor);
    }

    private final boolean hasConvertibleMethod(KtObjectDeclaration $this$hasConvertibleMethod) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtNamedFunction singleNamedMethod = this.singleNamedMethodOrNull($this$hasConvertibleMethod);
        KtNamedFunction ktNamedFunction = singleNamedMethod;
        KtExpression ktExpression3 = ktExpression2 = ktNamedFunction == null ? null : ktNamedFunction.getBodyExpression();
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression functionBody = ktExpression = ktExpression2;
        return KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)singleNamedMethod)) && !this.containsMethodOf(functionBody, $this$hasConvertibleMethod);
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitObjectLiteralExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtObjectDeclaration ktObjectDeclaration = expression.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"expression.objectDeclaration");
        KtObjectDeclaration declaration = ktObjectDeclaration;
        if (declaration.getName() == null && ((ktObjectDeclaration = this.getBindingContext().getType((KtExpression)expression)) == null ? false : ((kotlinType = this.singleSuperTypeOrNull((KotlinType)ktObjectDeclaration)) == null ? false : this.getCouldBeSamInterface(kotlinType))) && this.hasConvertibleMethod(declaration)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public ObjectLiteralToLambda() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isImplicitClassFor(ObjectLiteralToLambda $this, ReceiverValue $receiver, DeclarationDescriptor descriptor) {
        return $this.isImplicitClassFor($receiver, descriptor);
    }
}

