/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.SpacingBetweenPackageAndImports$checkKtElementsDeclaration$;
import io.gitlab.arturbosch.detekt.rules.style.SpacingBetweenPackageAndImports$visitKtFile$;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0014*\u00020\u0017H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SpacingBetweenPackageAndImports;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkKtElementsDeclaration", "", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "checkLinebreakAfterElement", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "message", "", "checkPackageDeclaration", "isPackageDeclaration", "", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasPackage", "detekt-rules-style"})
public final class SpacingBetweenPackageAndImports
extends Rule {
    @NotNull
    private final Issue issue;

    public SpacingBetweenPackageAndImports(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Violation of the package declaration style.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SpacingBetweenPackageAndImports(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.hasPackage(file)) {
            KtImportList ktImportList;
            PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)file;
            Function1 predicate$iv = visitKtFile$$inlined$anyDescendantOfType$default$1.INSTANCE;
            boolean $i$f$anyDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtClassOrObject && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            boolean bl = (PsiElement)result$iv$iv$iv.element != null;
            if (bl && (ktImportList = file.getImportList()) != null) {
                KtImportList ktImportList2 = ktImportList;
                boolean bl2 = false;
                boolean bl3 = false;
                KtImportList it = ktImportList2;
                boolean bl4 = false;
                Collection collection = it.getImports();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.imports");
                collection = collection;
                boolean bl5 = false;
                if (!collection.isEmpty()) {
                    this.checkPackageDeclaration(it);
                    this.checkKtElementsDeclaration(it);
                }
            }
        }
    }

    private final boolean hasPackage(KtFile $this$hasPackage) {
        boolean bl;
        KtPackageDirective ktPackageDirective = $this$hasPackage.getPackageDirective();
        if (ktPackageDirective == null) {
            bl = false;
        } else {
            String string = ktPackageDirective.getName();
            if (string == null) {
                bl = false;
            } else {
                CharSequence charSequence = string;
                boolean bl2 = false;
                bl = charSequence.length() > 0;
            }
        }
        return bl;
    }

    private final void checkPackageDeclaration(KtImportList importList) {
        PsiElement prevSibling = importList.getPrevSibling();
        if (this.isPackageDeclaration(prevSibling) || prevSibling instanceof PsiWhiteSpace) {
            this.checkLinebreakAfterElement(prevSibling, "There should be exactly one empty line in between the package declaration and the list of imports.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPackageDeclaration(PsiElement element) {
        if (!(element instanceof KtPackageDirective)) return false;
        CharSequence charSequence = ((KtPackageDirective)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"element.text");
        charSequence = charSequence;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    private final void checkKtElementsDeclaration(KtImportList importList) {
        Sequence $this$filterIsInstance$iv = PsiUtilsKt.siblings$default((PsiElement)((PsiElement)importList), (boolean)false, (boolean)false, (int)1, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkKtElementsDeclaration$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        KtElement ktElement = (KtElement)SequencesKt.firstOrNull((Sequence)sequence);
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        PsiElement nextSibling = importList.getNextSibling();
        if (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof KtElement) {
            String string;
            String string2;
            KtClassOrObject ktClassOrObject;
            KtClassOrObject ktClassOrObject2 = ktClassOrObject = ktElement2 instanceof KtClassOrObject ? (KtClassOrObject)ktElement2 : null;
            String name = string2 = ktClassOrObject == null ? "the class or object" : ((string = ktClassOrObject.getName()) == null ? "the class or object" : string);
            this.checkLinebreakAfterElement(nextSibling, "There should be exactly one empty line in between the list of imports and the declaration of " + name + '.');
        }
    }

    private final void checkLinebreakAfterElement(PsiElement element, String message) {
        if (element instanceof PsiWhiteSpace || element instanceof KtElement) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
            CharSequence $this$count$iv = string;
            boolean $i$f$count = false;
            int count$iv = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int count = count$iv;
            if (count != 2) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), message, null, null, 24, null));
            }
        }
    }

    public SpacingBetweenPackageAndImports() {
        this(null, 1, null);
    }
}

