/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryAbstractClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "excludeAnnotatedClasses", "", "", "getExcludeAnnotatedClasses$annotations", "()V", "getExcludeAnnotatedClasses", "()Ljava/util/List;", "excludeAnnotatedClasses$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "noAbstractMember", "noConcreteMember", "hasNoConstructorParameter", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "report", "", "finding", "Lio/gitlab/arturbosch/detekt/api/Finding;", "visitClass", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "NamedClassMembers", "detekt-rules-style"})
public final class UnnecessaryAbstractClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String noConcreteMember;
    @NotNull
    private final String noAbstractMember;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedClasses$delegate;
    private AnnotationExcluder annotationExcluder;

    public UnnecessaryAbstractClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.noConcreteMember = "An abstract class without a concrete member can be refactored to an interface.";
        this.noAbstractMember = "An abstract class without an abstract member can be refactored to a concrete class.";
        this.issue = new Issue("UnnecessaryAbstractClass", Severity.Style, "An abstract class is unnecessary and can be refactored. An abstract class should have both abstract and concrete properties or functions. " + this.noConcreteMember + ' ' + this.noAbstractMember, Debt.Companion.getFIVE_MINS());
        this.excludeAnnotatedClasses$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object)"dagger.Module"), (Function1)excludeAnnotatedClasses.2.INSTANCE);
    }

    public /* synthetic */ UnnecessaryAbstractClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getExcludeAnnotatedClasses() {
        return (List)this.excludeAnnotatedClasses$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Allows you to provide a list of annotations that disable this check.")
    private static /* synthetic */ void getExcludeAnnotatedClasses$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.getExcludeAnnotatedClasses());
        super.visitKtFile(file);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isInterface() && KtPsiUtilKt.isAbstract((KtClass)klass)) {
            KtClassBody body = klass.getBody();
            if (body != null) {
                void $this$filterTo$iv$iv;
                PsiElement[] psiElementArray = body.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"body.children");
                Object[] $this$filter$iv = psiElementArray;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl = false;
                    if (!(it instanceof KtProperty || it instanceof KtNamedFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List namedMembers = (List)destination$iv$iv;
                NamedClassMembers namedClassMembers = new NamedClassMembers(klass, namedMembers);
                namedClassMembers.detectAbstractAndConcreteType();
            } else if (klass.getSuperTypeListEntries().isEmpty() && !this.hasNoConstructorParameter(klass)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), this.noAbstractMember, null, null, 24, null), klass);
            }
        }
        super.visitClass(klass);
    }

    private final void report(Finding finding, KtClass klass) {
        Object object = this.annotationExcluder;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            throw null;
        }
        AnnotationExcluder annotationExcluder = object;
        object = klass.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"klass.annotationEntries");
        if (!annotationExcluder.shouldExclude((List)object)) {
            this.report(finding);
        }
    }

    private final boolean hasNoConstructorParameter(KtClass klass) {
        KtPrimaryConstructor primaryConstructor = klass.getPrimaryConstructor();
        return primaryConstructor == null || !CollectionsKt.any((Iterable)primaryConstructor.getValueParameters());
    }

    public UnnecessaryAbstractClass() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(UnnecessaryAbstractClass.class), "excludeAnnotatedClasses", "getExcludeAnnotatedClasses()Ljava/util/List;")))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass$NamedClassMembers;", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "namedMembers", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "getKlass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "getNamedMembers", "()Ljava/util/List;", "detectAbstractAndConcreteType", "", "hasInheritedMember", "", "isAbstract", "hasNoConcreteMemberLeft", "indexOfFirstMember", "", "members", "isAbstractClassWithoutConcreteMembers", "indexOfFirstAbstractMember", "detekt-rules-style"})
    private final class NamedClassMembers {
        @NotNull
        private final KtClass klass;
        @NotNull
        private final List<PsiElement> namedMembers;

        public NamedClassMembers(@NotNull KtClass klass, List<? extends PsiElement> namedMembers) {
            Intrinsics.checkNotNullParameter((Object)((Object)UnnecessaryAbstractClass.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter(namedMembers, (String)"namedMembers");
            this.klass = klass;
            this.namedMembers = namedMembers;
        }

        @NotNull
        public final KtClass getKlass() {
            return this.klass;
        }

        @NotNull
        public final List<PsiElement> getNamedMembers() {
            return this.namedMembers;
        }

        public final void detectAbstractAndConcreteType() {
            int firstAbstractMemberIndex = NamedClassMembers.indexOfFirstMember$default(this, true, null, 2, null);
            if (firstAbstractMemberIndex == -1 && !this.hasInheritedMember(true)) {
                UnnecessaryAbstractClass.this.report((Finding)new CodeSmell(UnnecessaryAbstractClass.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)this.klass), (int)0, (int)2, null), UnnecessaryAbstractClass.this.noAbstractMember, null, null, 24, null), this.klass);
            } else if (this.isAbstractClassWithoutConcreteMembers(firstAbstractMemberIndex) && !this.hasInheritedMember(false)) {
                UnnecessaryAbstractClass.this.report((Finding)new CodeSmell(UnnecessaryAbstractClass.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)this.klass), (int)0, (int)2, null), UnnecessaryAbstractClass.this.noConcreteMember, null, null, 24, null), this.klass);
            }
        }

        private final int indexOfFirstMember(boolean isAbstract, List<? extends PsiElement> members) {
            int n;
            block2: {
                List<? extends PsiElement> $this$indexOfFirst$iv = members;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends PsiElement> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    PsiElement item$iv;
                    PsiElement it = item$iv = iterator.next();
                    boolean bl = false;
                    if (it instanceof KtNamedDeclaration && KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)it)) == isAbstract) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        static /* synthetic */ int indexOfFirstMember$default(NamedClassMembers namedClassMembers, boolean bl, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = namedClassMembers.namedMembers;
            }
            return namedClassMembers.indexOfFirstMember(bl, list);
        }

        private final boolean isAbstractClassWithoutConcreteMembers(int indexOfFirstAbstractMember) {
            return indexOfFirstAbstractMember == 0 && this.hasNoConcreteMemberLeft() && UnnecessaryAbstractClass.this.hasNoConstructorParameter(this.klass);
        }

        private final boolean hasNoConcreteMemberLeft() {
            return this.indexOfFirstMember(false, CollectionsKt.drop((Iterable)this.namedMembers, (int)1)) == -1;
        }

        private final boolean hasInheritedMember(boolean isAbstract) {
            boolean bl;
            block8: {
                if (this.klass.getSuperTypeListEntries().isEmpty()) {
                    bl = false;
                } else if (Intrinsics.areEqual((Object)UnnecessaryAbstractClass.this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                    bl = true;
                } else {
                    MemberScope memberScope;
                    Object object = UnnecessaryAbstractClass.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.klass);
                    ClassDescriptor descriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
                    object = descriptor;
                    object = object == null ? null : ((memberScope = object.getUnsubstitutedMemberScope()) == null ? null : ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)((ResolutionScope)memberScope), null, null, (int)3, null));
                    boolean bl2 = false;
                    Object object2 = object;
                    if (object2 == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    Iterable $this$any$iv = (Iterable)object2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                            boolean bl3 = false;
                            MemberDescriptor memberDescriptor = it instanceof MemberDescriptor ? (MemberDescriptor)it : null;
                            if (!((memberDescriptor == null ? null : memberDescriptor.getModality()) == Modality.ABSTRACT == isAbstract)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }
    }
}

