/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isCalling", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Companion", "SecondCall", "detekt-rules-style"})
public final class UnnecessaryFilter
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> filterFqNames;
    @NotNull
    private static final List<SecondCall> secondCalls;

    public UnnecessaryFilter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryFilter", Severity.Style, "filter() with other collection operations may be simplified.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryFilter(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (!this.isCalling((KtExpression)expression, filterFqNames)) {
            return;
        }
        KtLambdaExpression ktLambdaExpression = this.lambda(expression);
        String string3 = string2 = ktLambdaExpression == null ? null : ktLambdaExpression.getText();
        if (string2 == null) {
            return;
        }
        String lambdaArgumentText = string = string2;
        KtExpression qualifiedOrCall = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)expression));
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)qualifiedOrCall);
        KtExpression ktExpression = ktLambdaExpression = ktQualifiedExpression == null ? null : ktQualifiedExpression.getSelectorExpression();
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression nextCall = ktLambdaExpression;
        Iterable $this$forEach$iv = secondCalls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SecondCall it = (SecondCall)element$iv;
            boolean bl = false;
            if (!this.isCalling((KtExpression)nextCall, it.getFqName())) continue;
            String message = '\'' + expression.getText() + "' can be replaced by '" + it.getCorrectOperator() + ' ' + lambdaArgumentText + '\'';
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtValueArgument ktValueArgument;
        List list = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
        if (ktLambdaArgument == null) {
            list = $this$lambda.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueArguments");
            ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list);
        } else {
            ktValueArgument = (KtValueArgument)ktLambdaArgument;
        }
        KtValueArgument argument = ktValueArgument;
        ktLambdaArgument = argument;
        return ktLambdaArgument == null ? null : ((list = ktLambdaArgument.getArgumentExpression()) == null ? null : KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)list, (boolean)false, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        CallableDescriptor callableDescriptor;
        void $this$filterTo$iv$iv;
        KtExpression ktExpression;
        KtCallExpression ktCallExpression;
        KtCallExpression ktCallExpression2 = ktCallExpression = $this$isCalling instanceof KtCallExpression ? (KtCallExpression)$this$isCalling : null;
        String string = ktCallExpression == null ? null : ((ktExpression = ktCallExpression.getCalleeExpression()) == null ? null : ktExpression.getText());
        String calleeText = string == null ? $this$isCalling.getText() : string;
        Iterable $this$filter$iv = fqNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.shortName().asString(), (Object)calleeText)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetFqNames = (List)destination$iv$iv;
        if (targetFqNames.isEmpty()) {
            return false;
        }
        ktCallExpression = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isCalling), (BindingContext)this.getBindingContext());
        return CollectionsKt.contains((Iterable)targetFqNames, ktCallExpression == null ? null : ((callableDescriptor = ktCallExpression.getResultingDescriptor()) == null ? null : DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))));
    }

    private final boolean isCalling(KtExpression $this$isCalling, FqName fqName) {
        return this.isCalling($this$isCalling, CollectionsKt.listOf((Object)fqName));
    }

    public UnnecessaryFilter() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.collections.filter"), new FqName("kotlin.sequences.filter")};
        filterFqNames = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new SecondCall[]{new SecondCall(new FqName("kotlin.collections.List.size"), null, 2, null), new SecondCall(new FqName("kotlin.collections.List.isEmpty"), "any"), new SecondCall(new FqName("kotlin.collections.isNotEmpty"), "none"), new SecondCall(new FqName("kotlin.collections.count"), null, 2, null), new SecondCall(new FqName("kotlin.sequences.count"), null, 2, null)};
        secondCalls = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$SecondCall;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "correctOperator", "", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "getCorrectOperator", "()Ljava/lang/String;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class SecondCall {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String correctOperator;

        public SecondCall(@NotNull FqName fqName, @NotNull String correctOperator) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)correctOperator, (String)"correctOperator");
            this.fqName = fqName;
            this.correctOperator = correctOperator;
        }

        public /* synthetic */ SecondCall(FqName fqName, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                String string2 = fqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"class SecondCall(val fqName: FqName, val correctOperator: String = fqName.shortName().asString())");
                string = string2;
            }
            this(fqName, string);
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final String getCorrectOperator() {
            return this.correctOperator;
        }

        @NotNull
        public final FqName component1() {
            return this.fqName;
        }

        @NotNull
        public final String component2() {
            return this.correctOperator;
        }

        @NotNull
        public final SecondCall copy(@NotNull FqName fqName, @NotNull String correctOperator) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)correctOperator, (String)"correctOperator");
            return new SecondCall(fqName, correctOperator);
        }

        public static /* synthetic */ SecondCall copy$default(SecondCall secondCall, FqName fqName, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = secondCall.fqName;
            }
            if ((n & 2) != 0) {
                string = secondCall.correctOperator;
            }
            return secondCall.copy(fqName, string);
        }

        @NotNull
        public String toString() {
            return "SecondCall(fqName=" + this.fqName + ", correctOperator=" + this.correctOperator + ')';
        }

        public int hashCode() {
            int result = this.fqName.hashCode();
            result = result * 31 + this.correctOperator.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SecondCall)) {
                return false;
            }
            SecondCall secondCall = (SecondCall)other;
            if (!Intrinsics.areEqual((Object)this.fqName, (Object)secondCall.fqName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.correctOperator, (Object)secondCall.correctOperator);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$Companion;", "", "()V", "filterFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "secondCalls", "Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$SecondCall;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

