/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UntilInsteadOfRangeTo;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "minimumSize", "", "isUntilApplicable", "", "range", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "([Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)Z", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "detekt-rules-style"})
public final class UntilInsteadOfRangeTo
extends Rule {
    @NotNull
    private final Issue issue;
    private final int minimumSize;

    public UntilInsteadOfRangeTo(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "'..' call can be replaced with 'until'", Debt.Companion.getFIVE_MINS());
        this.minimumSize = 3;
    }

    public /* synthetic */ UntilInsteadOfRangeTo(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement[] psiElementArray = expression.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"expression.children");
        if (this.isUntilApplicable(psiElementArray)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "'..' call can be replaced with 'until'", null, null, 24, null));
        }
        super.visitBinaryExpression(expression);
    }

    private final boolean isUntilApplicable(PsiElement[] range) {
        KtBinaryExpression expression;
        PsiElement psiElement;
        if (range.length >= this.minimumSize && range[1] instanceof KtOperationReferenceExpression && Intrinsics.areEqual((Object)range[1].getText(), (Object)"..") && Intrinsics.areEqual((Object)((psiElement = (expression = (psiElement = range[2]) instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null)) == null ? null : psiElement.getOperationToken()), (Object)KtTokens.MINUS)) {
            KtBinaryExpression ktBinaryExpression = expression;
            KtExpression ktExpression = ktBinaryExpression == null ? null : ktBinaryExpression.getRight();
            KtConstantExpression rightExpressionValue = ktExpression instanceof KtConstantExpression ? (KtConstantExpression)ktExpression : null;
            ktExpression = rightExpressionValue;
            return Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)"1");
        }
        return false;
    }

    public UntilInsteadOfRangeTo() {
        this(null, 1, null);
    }
}

