/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesLoops$checkForBraces$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\rH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesLoops;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkForBraces", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitDoWhileExpression", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "isNotBlockExpression", "", "detekt-rules-style"})
public final class MandatoryBracesLoops
extends Rule {
    @NotNull
    private final Issue issue;

    public MandatoryBracesLoops(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MandatoryBracesLoops", Severity.Style, "Multi-line loop was found that does not have braces. These should be added to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MandatoryBracesLoops(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitForExpression(@NotNull KtForExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces((KtLoopExpression)expression);
        super.visitForExpression(expression);
    }

    public void visitWhileExpression(@NotNull KtWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces((KtLoopExpression)expression);
        super.visitWhileExpression(expression);
    }

    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForBraces(expression);
        super.visitDoWhileExpression(expression);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForBraces(KtLoopExpression expression) {
        if (this.isNotBlockExpression(expression)) {
            boolean hasNoBraces2;
            Sequence sequence;
            PsiWhiteSpace psiWhiteSpace;
            PsiElement psiElement = expression.getRightParenthesis();
            if (psiElement == null) {
                psiWhiteSpace = null;
            } else {
                sequence = PsiUtilsKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)false);
                if (sequence == null) {
                    psiWhiteSpace = null;
                } else {
                    Sequence $this$filterIsInstance$iv;
                    Sequence sequence2 = sequence;
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkForBraces$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    Sequence sequence4 = sequence3;
                    if (sequence4 == null) {
                        psiWhiteSpace = null;
                    } else {
                        Object v2;
                        block10: {
                            void $this$firstOrNull$iv;
                            $this$filterIsInstance$iv = sequence4;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                                boolean bl = false;
                                if (!it.textContains('\n')) continue;
                                v2 = element$iv;
                                break block10;
                            }
                            v2 = null;
                        }
                        psiWhiteSpace = v2;
                    }
                }
            }
            boolean bl = hasNoBraces2 = psiWhiteSpace != null;
            if (hasNoBraces2) {
                Issue issue = this.getIssue();
                sequence = expression.getBody();
                psiElement = sequence == null ? (KtExpression)expression : sequence;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.body ?: expression");
                this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), "Multi-line loop was found that does not have braces. These should be added to improve readability.", null, null, 24, null));
            }
        }
    }

    private final void checkForBraces(KtDoWhileExpression expression) {
        if (this.isNotBlockExpression((KtLoopExpression)expression) && LinesOfCodeKt.linesOfCode$default((KtElement)((KtElement)expression), null, (int)1, null) > 1) {
            boolean hasNoBraces2;
            Object v1;
            block4: {
                Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)expression), (boolean)true, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(expression){
                    final /* synthetic */ KtDoWhileExpression $expression;
                    {
                        this.$expression = $expression;
                        super(1);
                    }

                    public final boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !Intrinsics.areEqual((Object)it, (Object)this.$expression.getWhileKeyword());
                    }
                }));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkForBraces$$inlined$filterIsInstance$2.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$firstOrNull$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                    boolean bl = false;
                    if (!it.textContains('\n')) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            boolean bl = hasNoBraces2 = v1 != null;
            if (hasNoBraces2) {
                Issue issue = this.getIssue();
                KtExpression ktExpression = expression.getBody();
                KtExpression ktExpression2 = ktExpression == null ? (KtExpression)expression : ktExpression;
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.body ?: expression");
                this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ktExpression2), (int)0, (int)2, null), "Multi-line loop was found that does not have braces. These should be added to improve readability.", null, null, 24, null));
            }
        }
    }

    private final boolean isNotBlockExpression(KtLoopExpression $this$isNotBlockExpression) {
        return !($this$isNotBlockExpression.getBody() instanceof KtBlockExpression);
    }

    public MandatoryBracesLoops() {
        this(null, 1, null);
    }
}

