/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CollapsibleIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasOneKtIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isLoneIfExpression", "statement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isNotElseIfOrElse", "visitIfExpression", "", "detekt-rules-style"})
public final class CollapsibleIfStatements
extends Rule {
    @NotNull
    private final Issue issue;

    public CollapsibleIfStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("CollapsibleIfStatements", Severity.Style, "Two if statements which could be collapsed were detected. These statements can be merged to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ CollapsibleIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isNotElseIfOrElse(expression) && this.hasOneKtIfExpression(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitIfExpression(expression);
    }

    private final boolean isNotElseIfOrElse(KtIfExpression expression) {
        return expression.getElse() == null && !(expression.getParent() instanceof KtContainerNodeForControlStructureBody);
    }

    private final boolean hasOneKtIfExpression(KtIfExpression expression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = expression.getThen();
        if (ktExpression2 == null) {
            ktExpression = null;
        } else {
            PsiElement $this$getChildrenOfType$iv = (PsiElement)ktExpression2;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtExpression.class);
            Object[] objectArray = (KtExpression[])(psiElementArray == null ? (PsiElement[])new KtExpression[0] : psiElementArray);
            ktExpression = (KtExpression)ArraysKt.singleOrNull((Object[])objectArray);
        }
        KtExpression statement = ktExpression;
        return statement != null && this.isLoneIfExpression((PsiElement)statement);
    }

    private final boolean isLoneIfExpression(PsiElement statement) {
        KtIfExpression ifExpression = statement instanceof KtIfExpression ? (KtIfExpression)statement : null;
        return ifExpression != null && ifExpression.getElse() == null;
    }

    public CollapsibleIfStatements() {
        this(null, 1, null);
    }
}

