/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ExpressionBodySyntax;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0006*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u0013H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "includeLineWrapping", "", "getIncludeLineWrapping$annotations", "()V", "getIncludeLineWrapping", "()Z", "includeLineWrapping$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isLineWrapped", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "containsReturnStmtsInNullableArguments", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "singleReturnStatement", "detekt-rules-style"})
public final class ExpressionBodySyntax
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty includeLineWrapping$delegate;

    public ExpressionBodySyntax(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Functions with exact one statement, the return statement, can be rewritten with ExpressionBodySyntax.", Debt.Companion.getFIVE_MINS());
        this.includeLineWrapping$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ExpressionBodySyntax(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIncludeLineWrapping() {
        return (Boolean)this.includeLineWrapping$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="include return statements with line wraps in it")
    private static /* synthetic */ void getIncludeLineWrapping$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        KtReturnExpression stmt;
        Object object;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression == null) {
            object = null;
        } else {
            KtReturnExpression ktReturnExpression = this.singleReturnStatement(ktExpression);
            if (ktReturnExpression == null) {
                object = null;
            } else {
                KtReturnExpression ktReturnExpression2 = ktReturnExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtReturnExpression it = ktReturnExpression2;
                boolean bl3 = false;
                object = stmt = !this.containsReturnStmtsInNullableArguments(it) ? ktReturnExpression2 : null;
            }
        }
        if (stmt != null && (this.getIncludeLineWrapping() || !this.isLineWrapped((KtExpression)stmt))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)stmt), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final KtReturnExpression singleReturnStatement(KtExpression $this$singleReturnStatement) {
        List list;
        KtBlockExpression ktBlockExpression;
        KtBlockExpression ktBlockExpression2 = ktBlockExpression = $this$singleReturnStatement instanceof KtBlockExpression ? (KtBlockExpression)$this$singleReturnStatement : null;
        KtExpression ktExpression = ktBlockExpression == null ? null : ((list = ktBlockExpression.getStatements()) == null ? null : (KtExpression)CollectionsKt.singleOrNull((List)list));
        return ktExpression instanceof KtReturnExpression ? (KtReturnExpression)ktExpression : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsReturnStmtsInNullableArguments(KtReturnExpression $this$containsReturnStmtsInNullableArguments) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsReturnStmtsInNullableArguments;
        Function1 predicate$iv = containsReturnStmtsInNullableArguments.1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isLineWrapped(KtExpression expression) {
        boolean bl;
        block1: {
            PsiElement[] psiElementArray = expression.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"expression.children");
            Object[] $this$any$iv = psiElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                if (!StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public ExpressionBodySyntax() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExpressionBodySyntax.class), "includeLineWrapping", "getIncludeLineWrapping()Z")))};
        $$delegatedProperties = kPropertyArray;
    }
}

