/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenComment$visitKtFile$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\f\u0012\u0004\b\u0014\u0010\b\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenComment;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPatterns", "Lkotlin/text/Regex;", "getAllowedPatterns$annotations", "()V", "getAllowedPatterns", "()Lkotlin/text/Regex;", "allowedPatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "values", "", "", "getValues$annotations", "getValues", "()Ljava/util/List;", "values$delegate", "checkForbiddenComment", "", "text", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitComment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules-style"})
public final class ForbiddenComment
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty values$delegate;
    @NotNull
    private final ReadOnlyProperty allowedPatterns$delegate;

    public ForbiddenComment(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        Object[] objectArray = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"javaClass.simpleName");
        this.issue = new Issue((String)objectArray, Severity.Style, "Flags a forbidden comment.", Debt.Companion.getTEN_MINS());
        objectArray = new String[]{"FIXME:", "STOPSHIP:", "TODO:"};
        this.values$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray));
        this.allowedPatterns$delegate = ConfigPropertyKt.config((Object)"", (Function1)allowedPatterns.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenComment(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getValues() {
        return (List)this.values$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="forbidden comment strings")
    private static /* synthetic */ void getValues$annotations() {
    }

    private final Regex getAllowedPatterns() {
        return (Regex)this.allowedPatterns$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores comments which match the specified regular expression. For example `Ticket|Task`.")
    private static /* synthetic */ void getAllowedPatterns$annotations() {
    }

    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        super.visitComment(comment);
        String text = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
        this.checkForbiddenComment(text, (PsiElement)comment);
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)file;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KDocSection, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDocSection) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KDocSection comment = (KDocSection)element$iv;
            boolean bl = false;
            String text = comment.getContent();
            this.checkForbiddenComment(text, (PsiElement)comment);
        }
    }

    private final void checkForbiddenComment(String text, PsiElement comment) {
        CharSequence charSequence = this.getAllowedPatterns().getPattern();
        boolean bl = false;
        if (charSequence.length() > 0 && this.getAllowedPatterns().containsMatchIn((CharSequence)text)) {
            return;
        }
        Iterable $this$forEach$iv = this.getValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            if (!StringsKt.contains((CharSequence)text, (CharSequence)it, (boolean)true)) continue;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)comment, (int)0, (int)2, null), "This comment contains '" + it + "' that has been defined as forbidden in detekt.", null, null, 24, null));
        }
    }

    public ForbiddenComment() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ForbiddenComment.class), "values", "getValues()Ljava/util/List;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ForbiddenComment.class), "allowedPatterns", "getAllowedPatterns()Lkotlin/text/Regex;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

