/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 V2\u00020\u0001:\u0001VB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@H\u0002J\u0010\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020@H\u0002J\u0019\u0010D\u001a\u0004\u0018\u00010+2\b\u0010E\u001a\u0004\u0018\u00010@H\u0002\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u00020H2\u0006\u0010=\u001a\u00020>H\u0016J\f\u0010I\u001a\u00020\u0006*\u00020JH\u0002J\f\u0010K\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010L\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010M\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010N\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010O\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010P\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010Q\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010R\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010S\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010T\u001a\u00020\u0006*\u00020>H\u0002J\f\u0010U\u001a\u00020\u0006*\u00020>H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR!\u0010\u0015\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\f\u0012\u0004\b\u0016\u0010\b\u001a\u0004\b\u0017\u0010\nR!\u0010\u0019\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\f\u0012\u0004\b\u001a\u0010\b\u001a\u0004\b\u001b\u0010\nR!\u0010\u001d\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\f\u0012\u0004\b\u001e\u0010\b\u001a\u0004\b\u001f\u0010\nR!\u0010!\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\f\u0012\u0004\b\"\u0010\b\u001a\u0004\b#\u0010\nR!\u0010%\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\f\u0012\u0004\b&\u0010\b\u001a\u0004\b'\u0010\nR'\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\f\u0012\u0004\b,\u0010\b\u001a\u0004\b-\u0010.R!\u00100\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\f\u0012\u0004\b1\u0010\b\u001a\u0004\b2\u0010\nR!\u00104\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010\f\u0012\u0004\b5\u0010\b\u001a\u0004\b6\u0010\nR\u0014\u00108\u001a\u000209X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006W"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreAnnotation", "", "getIgnoreAnnotation$annotations", "()V", "getIgnoreAnnotation", "()Z", "ignoreAnnotation$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreCompanionObjectPropertyDeclaration", "getIgnoreCompanionObjectPropertyDeclaration$annotations", "getIgnoreCompanionObjectPropertyDeclaration", "ignoreCompanionObjectPropertyDeclaration$delegate", "ignoreConstantDeclaration", "getIgnoreConstantDeclaration$annotations", "getIgnoreConstantDeclaration", "ignoreConstantDeclaration$delegate", "ignoreEnums", "getIgnoreEnums$annotations", "getIgnoreEnums", "ignoreEnums$delegate", "ignoreExtensionFunctions", "getIgnoreExtensionFunctions$annotations", "getIgnoreExtensionFunctions", "ignoreExtensionFunctions$delegate", "ignoreHashCodeFunction", "getIgnoreHashCodeFunction$annotations", "getIgnoreHashCodeFunction", "ignoreHashCodeFunction$delegate", "ignoreLocalVariableDeclaration", "getIgnoreLocalVariableDeclaration$annotations", "getIgnoreLocalVariableDeclaration", "ignoreLocalVariableDeclaration$delegate", "ignoreNamedArgument", "getIgnoreNamedArgument$annotations", "getIgnoreNamedArgument", "ignoreNamedArgument$delegate", "ignoreNumbers", "", "", "getIgnoreNumbers$annotations", "getIgnoreNumbers", "()Ljava/util/List;", "ignoreNumbers$delegate", "ignorePropertyDeclaration", "getIgnorePropertyDeclaration$annotations", "getIgnorePropertyDeclaration", "ignorePropertyDeclaration$delegate", "ignoreRanges", "getIgnoreRanges$annotations", "getIgnoreRanges", "ignoreRanges$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isIgnoredByConfig", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "normalizeForParsingAsDouble", "", "text", "parseAsDouble", "rawNumber", "parseAsDoubleOrNull", "rawToken", "(Ljava/lang/String;)Ljava/lang/Double;", "visitConstantExpression", "", "hasUnaryMinusPrefix", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isCompanionObjectProperty", "isConstantProperty", "isInCompanionObject", "isLocalProperty", "isNamedArgument", "isPartOfConstructorOrFunctionConstant", "isPartOfFunctionReturnConstant", "isPartOfHashCode", "isPartOfRange", "isProperty", "isSubjectOfExtensionFunction", "Companion", "detekt-rules-style"})
public final class MagicNumber
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreNumbers$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreHashCodeFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignorePropertyDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreLocalVariableDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreConstantDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreCompanionObjectPropertyDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotation$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreNamedArgument$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreEnums$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreRanges$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreExtensionFunctions$delegate;
    private static final int HEX_RADIX = 16;
    private static final int BINARY_RADIX = 2;

    public MagicNumber(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        Object[] objectArray = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"javaClass.simpleName");
        this.issue = new Issue((String)objectArray, Severity.Style, "Report magic numbers. Magic number is a numeric literal that is not defined as a constant and hence it's unclear what the purpose of this number is. It's better to declare such numbers as constants and give them a proper name. By default, -1, 0, 1, and 2 are not considered to be magic numbers.", Debt.Companion.getTEN_MINS());
        objectArray = new String[]{"-1", "0", "1", "2"};
        this.ignoreNumbers$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), (Function1)((Function1)new Function1<List<? extends String>, List<? extends Double>>(this){
            final /* synthetic */ MagicNumber this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Double> invoke(@NotNull List<String> numbers) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
                Iterable iterable = numbers;
                MagicNumber magicNumber = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Double d = MagicNumber.access$parseAsDouble(magicNumber, (String)p0);
                    collection.add(d);
                }
                return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            }
        }));
        this.ignoreHashCodeFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.ignorePropertyDeclaration$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreLocalVariableDeclaration$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreConstantDeclaration$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreCompanionObjectPropertyDeclaration$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreAnnotation$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreNamedArgument$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreEnums$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreRanges$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreExtensionFunctions$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ MagicNumber(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Double> getIgnoreNumbers() {
        return (List)this.ignoreNumbers$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="numbers which do not count as magic numbers")
    private static /* synthetic */ void getIgnoreNumbers$annotations() {
    }

    private final boolean getIgnoreHashCodeFunction() {
        return (Boolean)this.ignoreHashCodeFunction$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="whether magic numbers in hashCode functions should be ignored")
    private static /* synthetic */ void getIgnoreHashCodeFunction$annotations() {
    }

    private final boolean getIgnorePropertyDeclaration() {
        return (Boolean)this.ignorePropertyDeclaration$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="whether magic numbers in property declarations should be ignored")
    private static /* synthetic */ void getIgnorePropertyDeclaration$annotations() {
    }

    private final boolean getIgnoreLocalVariableDeclaration() {
        return (Boolean)this.ignoreLocalVariableDeclaration$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="whether magic numbers in local variable declarations should be ignored")
    private static /* synthetic */ void getIgnoreLocalVariableDeclaration$annotations() {
    }

    private final boolean getIgnoreConstantDeclaration() {
        return (Boolean)this.ignoreConstantDeclaration$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="whether magic numbers in constant declarations should be ignored")
    private static /* synthetic */ void getIgnoreConstantDeclaration$annotations() {
    }

    private final boolean getIgnoreCompanionObjectPropertyDeclaration() {
        return (Boolean)this.ignoreCompanionObjectPropertyDeclaration$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    @Configuration(description="whether magic numbers in companion object declarations should be ignored")
    private static /* synthetic */ void getIgnoreCompanionObjectPropertyDeclaration$annotations() {
    }

    private final boolean getIgnoreAnnotation() {
        return (Boolean)this.ignoreAnnotation$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    @Configuration(description="whether magic numbers in annotations should be ignored")
    private static /* synthetic */ void getIgnoreAnnotation$annotations() {
    }

    private final boolean getIgnoreNamedArgument() {
        return (Boolean)this.ignoreNamedArgument$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    @Configuration(description="whether magic numbers in named arguments should be ignored")
    private static /* synthetic */ void getIgnoreNamedArgument$annotations() {
    }

    private final boolean getIgnoreEnums() {
        return (Boolean)this.ignoreEnums$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    @Configuration(description="whether magic numbers in enums should be ignored")
    private static /* synthetic */ void getIgnoreEnums$annotations() {
    }

    private final boolean getIgnoreRanges() {
        return (Boolean)this.ignoreRanges$delegate.getValue((Object)this, $$delegatedProperties[9]);
    }

    @Configuration(description="whether magic numbers in ranges should be ignored")
    private static /* synthetic */ void getIgnoreRanges$annotations() {
    }

    private final boolean getIgnoreExtensionFunctions() {
        return (Boolean)this.ignoreExtensionFunctions$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    @Configuration(description="whether magic numbers as subject of an extension function should be ignored")
    private static /* synthetic */ void getIgnoreExtensionFunctions$annotations() {
    }

    public void visitConstantExpression(@NotNull KtConstantExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IStubElementType iStubElementType = expression.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iStubElementType, (String)"expression.elementType");
        IStubElementType elementType = iStubElementType;
        if (!Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT) && !Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            return;
        }
        if (this.isIgnoredByConfig(expression) || this.isPartOfFunctionReturnConstant(expression) || this.isPartOfConstructorOrFunctionConstant(expression)) {
            return;
        }
        PsiElement parent = expression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
        String rawNumber = this.hasUnaryMinusPrefix(parent) ? parent.getText() : expression.getText();
        Double number = this.parseAsDoubleOrNull(rawNumber);
        if (number != null && !this.getIgnoreNumbers().contains(number)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This expression contains a magic number. Consider defining it to a well named constant.", null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnoredByConfig(KtConstantExpression expression) {
        boolean $i$f$getNonStrictParentOfType;
        PsiElement $this$getNonStrictParentOfType$iv$iv;
        boolean $i$f$isPartOf;
        PsiElement $this$isPartOf$iv;
        if (this.getIgnorePropertyDeclaration() && this.isProperty(expression)) {
            return true;
        }
        if (this.getIgnoreLocalVariableDeclaration() && this.isLocalProperty(expression)) {
            return true;
        }
        if (this.getIgnoreConstantDeclaration() && this.isConstantProperty(expression)) {
            return true;
        }
        if (this.getIgnoreCompanionObjectPropertyDeclaration() && this.isCompanionObjectProperty(expression)) {
            return true;
        }
        if (this.getIgnoreAnnotation()) {
            $this$isPartOf$iv = (PsiElement)expression;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.getIgnoreHashCodeFunction() && this.isPartOfHashCode(expression)) {
            return true;
        }
        if (this.getIgnoreEnums()) {
            $this$isPartOf$iv = (PsiElement)expression;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtEnumEntry.class, (boolean)false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.getIgnoreNamedArgument() && this.isNamedArgument(expression)) {
            return true;
        }
        if (this.getIgnoreRanges() && this.isPartOfRange(expression)) {
            return true;
        }
        if (!this.getIgnoreExtensionFunctions()) return false;
        if (!this.isSubjectOfExtensionFunction(expression)) return false;
        return true;
    }

    private final Double parseAsDoubleOrNull(String rawToken) {
        Object object;
        try {
            Double d;
            object = rawToken;
            if (object == null) {
                d = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                d = this.parseAsDouble((String)it);
            }
            object = d;
        }
        catch (NumberFormatException e) {
            object = null;
        }
        return object;
    }

    private final double parseAsDouble(String rawNumber) {
        double d;
        String normalizedText = this.normalizeForParsingAsDouble(rawNumber);
        if (StringsKt.startsWith$default((String)normalizedText, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)normalizedText, (String)"0X", (boolean)false, (int)2, null)) {
            String string = normalizedText;
            int n = 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            string = string3;
            n = 16;
            bl = false;
            d = Long.parseLong(string, CharsKt.checkRadix((int)n));
        } else if (StringsKt.startsWith$default((String)normalizedText, (String)"0b", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)normalizedText, (String)"0B", (boolean)false, (int)2, null)) {
            String string = normalizedText;
            int n = 2;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string = string5;
            n = 2;
            bl = false;
            d = Long.parseLong(string, CharsKt.checkRadix((int)n));
        } else {
            String string = normalizedText;
            boolean bl = false;
            d = Double.parseDouble(string);
        }
        return d;
    }

    private final String normalizeForParsingAsDouble(String text) {
        String string = text;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        boolean bl2 = false;
        String string3 = string;
        boolean bl3 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.replace$default((String)string5, (String)"_", (String)"", (boolean)false, (int)4, null), (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNamedArgument(KtConstantExpression $this$isNamedArgument) {
        PsiElement psiElement = $this$isNamedArgument.getParent();
        PsiElement psiElement2 = psiElement instanceof KtPrefixExpression ? $this$isNamedArgument.getParent().getParent() : $this$isNamedArgument.getParent();
        if (!(psiElement2 instanceof KtValueArgument)) return false;
        KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
        KtValueArgument valueArgument = ktValueArgument;
        psiElement2 = valueArgument;
        if (psiElement2 == null) {
            return false;
        }
        if (!psiElement2.isNamed()) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiElement $this$isPartOf$iv = (PsiElement)$this$isNamedArgument;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtCallElement.class, (boolean)false) == null) return false;
        return true;
    }

    private final boolean isPartOfFunctionReturnConstant(KtConstantExpression $this$isPartOfFunctionReturnConstant) {
        return $this$isPartOfFunctionReturnConstant.getParent() instanceof KtNamedFunction || $this$isPartOfFunctionReturnConstant.getParent() instanceof KtReturnExpression && $this$isPartOfFunctionReturnConstant.getParent().getParent().getChildren().length == 1;
    }

    private final boolean isPartOfConstructorOrFunctionConstant(KtConstantExpression $this$isPartOfConstructorOrFunctionConstant) {
        PsiElement psiElement;
        return $this$isPartOfConstructorOrFunctionConstant.getParent() instanceof KtParameter && (((psiElement = $this$isPartOfConstructorOrFunctionConstant.getParent().getParent().getParent()) instanceof KtNamedFunction ? true : psiElement instanceof KtPrimaryConstructor) ? true : psiElement instanceof KtSecondaryConstructor);
    }

    private final boolean isPartOfRange(KtConstantExpression $this$isPartOfRange) {
        PsiElement theParent = $this$isPartOfRange.getParent();
        Object[] objectArray = new String[]{"downTo", "until", "step"};
        Set rangeOperators = SetsKt.setOf((Object[])objectArray);
        return theParent instanceof KtBinaryExpression ? Intrinsics.areEqual((Object)((KtBinaryExpression)theParent).getOperationToken(), (Object)KtTokens.RANGE) || rangeOperators.contains(((KtBinaryExpression)theParent).getOperationReference().getReferencedName()) : false;
    }

    private final boolean isSubjectOfExtensionFunction(KtConstantExpression $this$isSubjectOfExtensionFunction) {
        return $this$isSubjectOfExtensionFunction.getParent() instanceof KtDotQualifiedExpression;
    }

    private final boolean isPartOfHashCode(KtConstantExpression $this$isPartOfHashCode) {
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isPartOfHashCode;
        boolean $i$f$getNonStrictParentOfType = false;
        KtNamedFunction containingFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
        KtNamedFunction ktNamedFunction = containingFunction;
        return ktNamedFunction == null ? false : MethodSignatureKt.isHashCodeFunction((KtFunction)((KtFunction)ktNamedFunction));
    }

    private final boolean isLocalProperty(KtConstantExpression $this$isLocalProperty) {
        boolean bl;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isLocalProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        return ktProperty == null ? false : (bl = ktProperty.isLocal());
    }

    private final boolean isProperty(KtConstantExpression $this$isProperty) {
        boolean bl;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        if (ktProperty == null) {
            bl = false;
        } else {
            boolean bl2;
            KtProperty ktProperty2 = ktProperty;
            boolean bl3 = false;
            boolean bl4 = false;
            KtProperty it = ktProperty2;
            boolean bl5 = false;
            bl = bl2 = !it.isLocal();
        }
        return bl;
    }

    private final boolean isCompanionObjectProperty(KtConstantExpression $this$isCompanionObjectProperty) {
        return this.isProperty($this$isCompanionObjectProperty) && this.isInCompanionObject($this$isCompanionObjectProperty);
    }

    private final boolean isInCompanionObject(KtConstantExpression $this$isInCompanionObject) {
        boolean bl;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isInCompanionObject;
        boolean $i$f$getNonStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)false);
        return ktObjectDeclaration == null ? false : (bl = ktObjectDeclaration.isCompanion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConstantProperty(KtConstantExpression $this$isConstantProperty) {
        boolean bl;
        if (!this.isProperty($this$isConstantProperty)) return false;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isConstantProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtProperty.class, (boolean)false);
        if (ktProperty == null) {
            return false;
        }
        boolean bl2 = bl = KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)ktProperty));
        if (!bl2) return false;
        return true;
    }

    private final boolean hasUnaryMinusPrefix(PsiElement $this$hasUnaryMinusPrefix) {
        PsiElement psiElement;
        KtOperationReferenceExpression ktOperationReferenceExpression;
        return $this$hasUnaryMinusPrefix instanceof KtPrefixExpression && Intrinsics.areEqual((Object)((ktOperationReferenceExpression = (psiElement = ((KtPrefixExpression)$this$hasUnaryMinusPrefix).getFirstChild()) instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement : null) == null ? null : ktOperationReferenceExpression.getOperationSignTokenType()), (Object)KtTokens.MINUS);
    }

    public MagicNumber() {
        this(null, 1, null);
    }

    public static final /* synthetic */ double access$parseAsDouble(MagicNumber $this, String rawNumber) {
        return $this.parseAsDouble(rawNumber);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreNumbers", "getIgnoreNumbers()Ljava/util/List;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreHashCodeFunction", "getIgnoreHashCodeFunction()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignorePropertyDeclaration", "getIgnorePropertyDeclaration()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreLocalVariableDeclaration", "getIgnoreLocalVariableDeclaration()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreConstantDeclaration", "getIgnoreConstantDeclaration()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreCompanionObjectPropertyDeclaration", "getIgnoreCompanionObjectPropertyDeclaration()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreAnnotation", "getIgnoreAnnotation()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreNamedArgument", "getIgnoreNamedArgument()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreEnums", "getIgnoreEnums()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreRanges", "getIgnoreRanges()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MagicNumber.class), "ignoreExtensionFunctions", "getIgnoreExtensionFunctions()Z")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber$Companion;", "", "()V", "BINARY_RADIX", "", "HEX_RADIX", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

