/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryLetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryLet;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-style"})
public final class UnnecessaryLet
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessaryLet(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The `let` usage is unnecessary", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (!UnnecessaryLetKt.access$isLetExpr(expression)) {
            return;
        }
        KtLambdaExpression lambdaExpr = UnnecessaryLetKt.access$getFirstLambdaArg(expression);
        boolean isNullSafeOperator = expression.getParent() instanceof KtSafeQualifiedExpression;
        if (lambdaExpr == null) {
            if (!isNullSafeOperator) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "let expression can be omitted", null, null, 24, null));
            }
        } else {
            int lambdaReferenceCount = UnnecessaryLetKt.access$countReferences(lambdaExpr, this.getBindingContext());
            if (lambdaReferenceCount == 0 && !JunkKt.receiverIsUsed((KtCallExpression)expression, (BindingContext)this.getBindingContext()) && isNullSafeOperator) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "let expression can be replaces with a simple if", null, null, 24, null));
            } else if (lambdaReferenceCount <= 1 && !isNullSafeOperator) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "let expression can be omitted", null, null, 24, null));
            } else if (lambdaReferenceCount == 1 && UnnecessaryLetKt.access$canBeReplacedWithCall(lambdaExpr)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "let expression can be omitted", null, null, 24, null));
            }
        }
    }
}

