/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.VarCouldBeValKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/VarCouldBeVal;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isSomehowNested", "", "AssignmentVisitor", "detekt-rules-style"})
public final class VarCouldBeVal
extends Rule {
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;

    public VarCouldBeVal(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"CanBeVal");
        this.issue = new Issue("VarCouldBeVal", Severity.Maintainability, "Var declaration could be val.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ VarCouldBeVal(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY) || this.isSomehowNested(function)) {
            return;
        }
        AssignmentVisitor assignmentVisitor = new AssignmentVisitor(this.getBindingContext());
        function.accept((PsiElementVisitor)assignmentVisitor);
        Iterable $this$forEach$iv = assignmentVisitor.getNonReAssignedDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), "Variable '" + it.getNameAsSafeName().getIdentifier() + "' could be val.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isSomehowNested(KtNamedFunction $this$isSomehowNested) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isSomehowNested;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true) != null;
    }

    public VarCouldBeVal() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000bH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/VarCouldBeVal$AssignmentVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "assignments", "", "", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "declarations", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getNonReAssignedDeclarations", "", "visitAssignment", "", "assignedExpression", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "hasAssignments", "", "detekt-rules-style"})
    private static final class AssignmentVisitor
    extends DetektVisitor {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final Set<KtNamedDeclaration> declarations;
        @NotNull
        private final Map<String, Set<KtExpression>> assignments;

        public AssignmentVisitor(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            this.bindingContext = bindingContext;
            boolean bl = false;
            this.declarations = new LinkedHashSet();
            bl = false;
            this.assignments = new LinkedHashMap();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtNamedDeclaration> getNonReAssignedDeclarations() {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.declarations;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (this.hasAssignments(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean hasAssignments(KtNamedDeclaration $this$hasAssignments) {
            boolean bl;
            block4: {
                String string = $this$hasAssignments.getNameAsSafeName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAsSafeName.toString()");
                String declarationName = string;
                Set<KtExpression> assignments = this.assignments.get(declarationName);
                Collection collection = assignments;
                boolean bl2 = false;
                boolean bl3 = false;
                if (collection == null || collection.isEmpty()) {
                    return false;
                }
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$hasAssignments);
                Iterable $this$any$iv = assignments;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl4 = false;
                        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this.bindingContext);
                        if (!Intrinsics.areEqual((Object)(resolvedCall == null ? null : resolvedCall.getResultingDescriptor()), (Object)declarationDescriptor)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            if (property.isVar()) {
                this.declarations.add((KtNamedDeclaration)property);
            }
            super.visitProperty(property);
        }

        public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (CollectionsKt.contains((Iterable)VarCouldBeValKt.access$getUnaryAssignmentOperators$p(), (Object)expression.getOperationToken())) {
                this.visitAssignment(expression.getBaseExpression());
            }
            super.visitUnaryExpression(expression);
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (KtTokens.ALL_ASSIGNMENTS.contains(expression.getOperationToken())) {
                this.visitAssignment(expression.getLeft());
            }
            super.visitBinaryExpression(expression);
        }

        private final void visitAssignment(KtExpression assignedExpression) {
            Set set;
            String string;
            if (assignedExpression == null) {
                return;
            }
            KtExpression ktExpression = assignedExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)assignedExpression).getSelectorExpression() : assignedExpression;
            String string2 = string = ktExpression == null ? null : ktExpression.getText();
            if (string == null) {
                return;
            }
            String name = string;
            Map<String, Set<KtExpression>> $this$getOrPut$iv = this.assignments;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(name);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(name, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add((KtExpression)assignedExpression);
        }
    }
}

