/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.DataClassContainsFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DataClassContainsFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "conversionFunctionPrefix", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "getConversionFunctionPrefix$annotations", "()V", "getConversionFunctionPrefix", "()Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "conversionFunctionPrefix$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkFunction", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "detekt-rules-style"})
public final class DataClassContainsFunctions
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty conversionFunctionPrefix$delegate;

    public DataClassContainsFunctions(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DataClassContainsFunctions", Severity.Style, "Data classes should mainly be used to store data and should not have any extra functions. (Compiler will automatically generate equals, toString and hashCode functions)", Debt.Companion.getTWENTY_MINS());
        this.conversionFunctionPrefix$delegate = ConfigPropertyKt.config((Object)"to", (Function1)conversionFunctionPrefix.2.INSTANCE);
    }

    public /* synthetic */ DataClassContainsFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final SplitPattern getConversionFunctionPrefix() {
        return (SplitPattern)this.conversionFunctionPrefix$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="allowed conversion function names")
    private static /* synthetic */ void getConversionFunctionPrefix$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull KtClass klass) {
        List list;
        KtClassBody ktClassBody;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.isData() && (ktClassBody = klass.getBody()) != null && (list = ktClassBody.getDeclarations()) != null) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = list;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it = (KtNamedFunction)element$iv;
                boolean bl = false;
                this.checkFunction(klass, it);
            }
        }
        super.visitClass(klass);
    }

    private final void checkFunction(KtClass klass, KtNamedFunction function) {
        if (!KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) && !this.getConversionFunctionPrefix().startWith(function.getName())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "The data class " + klass.getName() + " contains functions which are not registered conversion functions. The offending method is called " + function.getName(), null, null, 24, null));
        }
    }

    public DataClassContainsFunctions() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DataClassContainsFunctions.class, "conversionFunctionPrefix", "getConversionFunctionPrefix()Lio/gitlab/arturbosch/detekt/api/SplitPattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

