/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isCallerMap", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isIndexableGetter", "isIndexableSetter", "isOperatorFunction", "unusedReturnValue", "visitDotQualifiedExpression", "", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "detekt-rules-style"})
public final class ExplicitCollectionElementAccessMethod
extends Rule {
    @NotNull
    private final Issue issue;

    public ExplicitCollectionElementAccessMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ExplicitCollectionElementAccessMethod", Severity.Style, "Prefer usage of indexed access operator [] for map element access or insert methods", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ExplicitCollectionElementAccessMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
        KtCallExpression ktCallExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitDotQualifiedExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtExpression ktExpression = expression.getSelectorExpression();
        KtCallExpression ktCallExpression2 = ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression call = ktCallExpression;
        if (this.isIndexableGetter(call) || this.isIndexableSetter(call) && this.unusedReturnValue(call)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Prefer usage of indexed access operator [].", null, null, 24, null));
        }
    }

    private final boolean isIndexableGetter(KtCallExpression expression) {
        KtExpression ktExpression = expression.getCalleeExpression();
        return Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)"get") && this.isOperatorFunction(expression);
    }

    private final boolean isIndexableSetter(KtCallExpression expression) {
        String string;
        KtExpression ktExpression = expression.getCalleeExpression();
        String string2 = string = ktExpression == null ? null : ktExpression.getText();
        return Intrinsics.areEqual((Object)string, (Object)"set") ? this.isOperatorFunction(expression) : (Intrinsics.areEqual((Object)string, (Object)"put") ? this.isCallerMap(expression) : false);
    }

    private final boolean isOperatorFunction(KtCallExpression expression) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        CallableDescriptor callableDescriptor = resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
        FunctionDescriptor function = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        return (callableDescriptor = function) == null ? false : callableDescriptor.isOperator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallerMap(KtCallExpression expression) {
        KotlinType it;
        FqName fqName;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)expression));
        KtExpression caller = ktQualifiedExpression == null ? null : ktQualifiedExpression.getReceiverExpression();
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)caller), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (callableDescriptor == null) {
            return false;
        }
        KotlinType kotlinType = callableDescriptor.getReturnType();
        KotlinType type = kotlinType;
        if (type == null) return false;
        if (type instanceof ErrorType) {
            return false;
        }
        String mapName = "kotlin.collections.Map";
        callableDescriptor = TypeUtilsKt.fqNameOrNull((KotlinType)type);
        if (Intrinsics.areEqual((Object)(callableDescriptor == null ? null : callableDescriptor.asString()), (Object)mapName)) return true;
        Iterable $this$any$iv = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes((KotlinType)type);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)((fqName = TypeUtilsKt.fqNameOrNull((KotlinType)it)) == null ? null : fqName.asString()), (Object)mapName));
        return true;
    }

    private final boolean unusedReturnValue(KtCallExpression expression) {
        return expression.getParent().getParent() instanceof KtBlockExpression;
    }

    public ExplicitCollectionElementAccessMethod() {
        this(null, 1, null);
    }
}

