/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenImport;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\f\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenPatterns", "Lkotlin/text/Regex;", "getForbiddenPatterns$annotations", "()V", "getForbiddenPatterns", "()Lkotlin/text/Regex;", "forbiddenPatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "imports", "", "getImports$annotations", "getImports", "()Ljava/util/List;", "imports$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "containsForbiddenPattern", "", "import", "", "visitImportDirective", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "detekt-rules-style"})
public final class ForbiddenImport
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty imports$delegate;
    @NotNull
    private final ReadOnlyProperty forbiddenPatterns$delegate;

    public ForbiddenImport(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Mark forbidden imports. A forbidden import could be an import for an unstable / experimental apiand hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        this.imports$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)imports.2.INSTANCE);
        this.forbiddenPatterns$delegate = ConfigPropertyKt.config((Object)"", (Function1)forbiddenPatterns.2.INSTANCE);
    }

    public /* synthetic */ ForbiddenImport(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getImports() {
        return (List)this.imports$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="imports which should not be used")
    private static /* synthetic */ void getImports$annotations() {
    }

    private final Regex getForbiddenPatterns() {
        return (Regex)this.forbiddenPatterns$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="reports imports which match the specified regular expression. For example `net.*R`.")
    private static /* synthetic */ void getForbiddenPatterns$annotations() {
    }

    public void visitImportDirective(@NotNull KtImportDirective importDirective) {
        boolean bl;
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
            super.visitImportDirective(importDirective);
            Object object2 = importDirective.getImportedFqName();
            object2 = object2 == null ? null : object2.asString();
            boolean bl2 = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = "";
            }
            object = object3;
            Iterable $this$any$iv = this.getImports();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl3 = false;
                    if (!it.matches((CharSequence)object)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl || this.containsForbiddenPattern((String)object)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)importDirective), (int)0, (int)2, null), "The import " + (String)object + " has been forbidden in the Detekt config.", null, null, 24, null));
        }
    }

    private final boolean containsForbiddenPattern(String string) {
        CharSequence charSequence = this.getForbiddenPatterns().getPattern();
        boolean bl = false;
        return charSequence.length() > 0 && this.getForbiddenPatterns().containsMatchIn((CharSequence)string);
    }

    public ForbiddenImport() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenImport.class, "imports", "getImports()Ljava/util/List;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenImport.class, "forbiddenPatterns", "getForbiddenPatterns()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

