/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.FunctionOnlyReturningConstant;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010)\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\u00020\u00118BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u000f\u0012\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0016\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u000f\u0012\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001c\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u000f\u0012\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "excludeAnnotatedFunction", "", "", "getExcludeAnnotatedFunction$annotations", "()V", "getExcludeAnnotatedFunction", "()Ljava/util/List;", "excludeAnnotatedFunction$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludedFunctions", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "getExcludedFunctions$annotations", "getExcludedFunctions", "()Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "excludedFunctions$delegate", "ignoreActualFunction", "", "getIgnoreActualFunction$annotations", "getIgnoreActualFunction", "()Z", "ignoreActualFunction$delegate", "ignoreOverridableFunction", "getIgnoreOverridableFunction$annotations", "getIgnoreOverridableFunction", "ignoreOverridableFunction$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkActualFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkContainingInterface", "checkOverridableFunction", "isConstantExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNotExcluded", "isNotIgnored", "isReturningAConstant", "returnsConstant", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "detekt-rules-style"})
public final class FunctionOnlyReturningConstant
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreOverridableFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreActualFunction$delegate;
    @NotNull
    private final ReadOnlyProperty excludedFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedFunction$delegate;
    private AnnotationExcluder annotationExcluder;

    public FunctionOnlyReturningConstant(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A function that only returns a constant is misleading. Consider declaring a constant instead", Debt.Companion.getTEN_MINS());
        this.ignoreOverridableFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreActualFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.excludedFunctions$delegate = ConfigPropertyKt.config((Object)"", (Function1)excludedFunctions.2.INSTANCE);
        this.excludeAnnotatedFunction$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)excludeAnnotatedFunction.2.INSTANCE);
    }

    public /* synthetic */ FunctionOnlyReturningConstant(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverridableFunction() {
        return (Boolean)this.ignoreOverridableFunction$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if overriden functions should be ignored")
    private static /* synthetic */ void getIgnoreOverridableFunction$annotations() {
    }

    private final boolean getIgnoreActualFunction() {
        return (Boolean)this.ignoreActualFunction$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if actual functions should be ignored")
    private static /* synthetic */ void getIgnoreActualFunction$annotations() {
    }

    private final SplitPattern getExcludedFunctions() {
        return (SplitPattern)this.excludedFunctions$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="excluded functions")
    private static /* synthetic */ void getExcludedFunctions$annotations() {
    }

    private final List<String> getExcludeAnnotatedFunction() {
        return (List)this.excludeAnnotatedFunction$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="allows to provide a list of annotations that disable this check")
    @Deprecated(message="Use `ignoreAnnotated` instead")
    private static /* synthetic */ void getExcludeAnnotatedFunction$annotations() {
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.annotationExcluder = new AnnotationExcluder(root, this.getExcludeAnnotatedFunction());
        super.visit(root);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.isNotIgnored(function) && this.isNotExcluded(function) && this.isReturningAConstant(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), function.getNameAsSafeName() + " is returning a constant. Prefer declaring a constant instead.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isNotIgnored(KtNamedFunction function) {
        return this.checkOverridableFunction(function) && this.checkActualFunction(function);
    }

    private final boolean checkOverridableFunction(KtNamedFunction function) {
        return this.getIgnoreOverridableFunction() ? !(KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) || KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)function)) || this.checkContainingInterface(function)) : true;
    }

    private final boolean checkContainingInterface(KtNamedFunction function) {
        KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)function));
        return containingClass != null && containingClass.isInterface();
    }

    private final boolean checkActualFunction(KtNamedFunction function) {
        return this.getIgnoreActualFunction() ? !KtModifierListKt.isActual((KtModifierListOwner)((KtModifierListOwner)function)) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotExcluded(KtNamedFunction function) {
        AnnotationExcluder annotationExcluder;
        if (this.getExcludedFunctions().contains(function.getName())) return false;
        AnnotationExcluder annotationExcluder2 = this.annotationExcluder;
        if (annotationExcluder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            annotationExcluder = null;
        } else {
            annotationExcluder = annotationExcluder2;
        }
        List list = function.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.annotationEntries");
        if (annotationExcluder.shouldExclude(list)) return false;
        return true;
    }

    private final boolean isReturningAConstant(KtNamedFunction function) {
        return this.isConstantExpression(function.getBodyExpression()) || this.returnsConstant(function);
    }

    private final boolean isConstantExpression(KtExpression expression) {
        if (expression instanceof KtConstantExpression) {
            return true;
        }
        return expression instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)expression).hasInterpolation();
    }

    private final boolean returnsConstant(KtNamedFunction function) {
        Object[] objectArray;
        KtExpression ktExpression = function.getBodyExpression();
        PsiElement psiElement = ktExpression == null ? null : ((objectArray = ktExpression.getChildren()) == null ? null : (PsiElement)ArraysKt.singleOrNull((Object[])objectArray));
        KtReturnExpression returnExpression = psiElement instanceof KtReturnExpression ? (KtReturnExpression)psiElement : null;
        psiElement = returnExpression;
        return this.isConstantExpression(psiElement == null ? null : psiElement.getReturnedExpression());
    }

    public FunctionOnlyReturningConstant() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "ignoreOverridableFunction", "getIgnoreOverridableFunction()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "ignoreActualFunction", "getIgnoreActualFunction()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "excludedFunctions", "getExcludedFunctions()Lio/gitlab/arturbosch/detekt/api/SplitPattern;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "excludeAnnotatedFunction", "getExcludeAnnotatedFunction()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

