/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u00020\u001a8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\f\u0012\u0004\b\u001b\u0010\b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeCommentStatements", "", "getExcludeCommentStatements$annotations", "()V", "getExcludeCommentStatements", "()Z", "excludeCommentStatements$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludeImportStatements", "getExcludeImportStatements$annotations", "getExcludeImportStatements", "excludeImportStatements$delegate", "excludePackageStatements", "getExcludePackageStatements$annotations", "getExcludePackageStatements", "excludePackageStatements$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxLineLength", "", "getMaxLineLength$annotations", "getMaxLineLength", "()I", "maxLineLength$delegate", "containsIgnoredCommentStatement", "line", "", "containsIgnoredImportStatement", "containsIgnoredPackageStatement", "isIgnoredStatement", "isValidLine", "visit", "", "element", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "Companion", "detekt-rules-style"})
public final class MaxLineLength
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxLineLength$delegate;
    @NotNull
    private final ReadOnlyProperty excludePackageStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeImportStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeCommentStatements$delegate;
    private static final int DEFAULT_IDEA_LINE_LENGTH = 120;

    public MaxLineLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Line detected that is longer than the defined maximum line length in the code style.", Debt.Companion.getFIVE_MINS());
        this.maxLineLength$delegate = ConfigPropertyKt.config((Object)120);
        this.excludePackageStatements$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeImportStatements$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeCommentStatements$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ MaxLineLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxLineLength() {
        return ((Number)this.maxLineLength$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum line length")
    private static /* synthetic */ void getMaxLineLength$annotations() {
    }

    private final boolean getExcludePackageStatements() {
        return (Boolean)this.excludePackageStatements$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if package statements should be ignored")
    private static /* synthetic */ void getExcludePackageStatements$annotations() {
    }

    private final boolean getExcludeImportStatements() {
        return (Boolean)this.excludeImportStatements$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="if import statements should be ignored")
    private static /* synthetic */ void getExcludeImportStatements$annotations() {
    }

    private final boolean getExcludeCommentStatements() {
        return (Boolean)this.excludeCommentStatements$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="if comment statements should be ignored")
    private static /* synthetic */ void getExcludeCommentStatements$annotations() {
    }

    public final void visit(@NotNull KtFileContent element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int offset = 0;
        Sequence<String> lines = element.getContent();
        KtFile file = element.getFile();
        for (String line : lines) {
            offset += line.length();
            if (!this.isValidLine(line)) {
                PsiElement ktElement = JunkKt.findFirstKtElementInParents(file, offset, line);
                if (ktElement != null) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)ktElement, (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
                } else {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)file, offset), this.getIssue().getDescription(), null, null, 24, null));
                }
            }
            ++offset;
        }
    }

    private final boolean isValidLine(String line) {
        boolean isUrl = StringExtensionsKt.lastArgumentMatchesUrl((String)line);
        return line.length() <= this.getMaxLineLength() || this.isIgnoredStatement(line) || isUrl;
    }

    private final boolean isIgnoredStatement(String line) {
        return this.containsIgnoredPackageStatement(line) || this.containsIgnoredImportStatement(line) || this.containsIgnoredCommentStatement(line);
    }

    private final boolean containsIgnoredPackageStatement(String line) {
        if (!this.getExcludePackageStatements()) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"package ", (boolean)false, (int)2, null);
    }

    private final boolean containsIgnoredImportStatement(String line) {
        if (!this.getExcludeImportStatements()) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"import ", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsIgnoredCommentStatement(String line) {
        if (!this.getExcludeCommentStatements()) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"//", (boolean)false, (int)2, null)) return true;
        string = line;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string3)).toString(), (String)"/*", (boolean)false, (int)2, null)) return true;
        string = line;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string4)).toString(), (String)"*", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public MaxLineLength() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "maxLineLength", "getMaxLineLength()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludePackageStatements", "getExcludePackageStatements()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludeImportStatements", "getExcludeImportStatements()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludeCommentStatements", "getExcludeCommentStatements()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion;", "", "()V", "DEFAULT_IDEA_LINE_LENGTH", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

