/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IsPartOfUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NoTabs;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "findTabs", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isStringInterpolated", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "isTab", "detekt-rules-style"})
public final class NoTabs
extends Rule {
    @NotNull
    private final Issue issue;

    public NoTabs(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Checks if tabs are used in Kotlin files.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NoTabs(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public final void findTabs(@NotNull KtFile file) {
        void $this$forEachDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = (PsiElement)file;
        Function1 action$iv = (Function1)new Function1<PsiWhiteSpace, Unit>(this){
            final /* synthetic */ NoTabs this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PsiWhiteSpace it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (NoTabs.access$isTab(this.this$0, it)) {
                    this.this$0.report((Finding)new CodeSmell(this.this$0.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), "Tab character is in use.", null, null, 24, null));
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof PsiWhiteSpace) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTab(PsiWhiteSpace $this$isTab) {
        if (IsPartOfUtilsKt.isPartOfString((PsiElement)((PsiElement)$this$isTab))) {
            if (!this.isStringInterpolated($this$isTab)) return false;
        }
        String string = $this$isTab.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.contains$default((CharSequence)string, (char)'\t', (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isStringInterpolated(PsiWhiteSpace $this$isStringInterpolated) {
        PsiElement $this$isPartOf$iv = (PsiElement)$this$isStringInterpolated;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtStringTemplateEntryWithExpression.class, (boolean)false) != null;
    }

    public NoTabs() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isTab(NoTabs $this, PsiWhiteSpace $receiver) {
        return $this.isTab($receiver);
    }
}

