/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/OptionalWhenBraces;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "hasUnnecessaryBraces", "", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "detekt-rules-style"})
public final class OptionalWhenBraces
extends Rule {
    @NotNull
    private final Issue issue;

    public OptionalWhenBraces(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Optional braces in when expression", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalWhenBraces(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        for (KtWhenEntry entry : expression.getEntries()) {
            KtExpression ktExpression = entry.getExpression();
            KtBlockExpression blockExpression = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
            ktExpression = blockExpression;
            if (!(ktExpression == null ? false : this.hasUnnecessaryBraces((KtBlockExpression)ktExpression))) continue;
            Issue issue = this.getIssue();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)entry), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitWhenExpression(expression);
    }

    private final boolean hasUnnecessaryBraces(KtBlockExpression $this$hasUnnecessaryBraces) {
        List list;
        List list2 = $this$hasUnnecessaryBraces.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression == null) {
            list = null;
        } else {
            list2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            List it = list2;
            boolean bl3 = false;
            list = !(it instanceof KtLambdaExpression) || ((KtLambdaExpression)it).getFunctionLiteral().getArrow() != null ? list2 : null;
        }
        List singleStatement = list;
        return singleStatement != null && !JunkKt.hasCommentInside((PsiElement)((PsiElement)$this$hasUnnecessaryBraces)) && $this$hasUnnecessaryBraces.getLBrace() != null && $this$hasUnnecessaryBraces.getRBrace() != null;
    }

    public OptionalWhenBraces() {
        this(null, 1, null);
    }
}

