/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u0011*\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\u000fH\u0002J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u000fH\u0002J\u000e\u0010\u0017\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\f\u0010\u0019\u001a\u00020\u0011*\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000f*\u00020\fH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u001fH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isCalling", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "fqNames", "", "isCollectionOrArray", "isCollectionOrArrayOrString", "isEmptyString", "isNullKeyword", "isString", "isZero", "nullCheckedExpression", "sizeCheckedEmptyString", "sizeCheckedEqualToZero", "sizeCheckedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Companion", "detekt-rules-style"})
public final class UseIsNullOrEmpty
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> collectionClasses;
    @NotNull
    private static final FqName arrayClass;
    @NotNull
    private static final FqName stringClass;
    @NotNull
    private static final List<FqName> emptyCheckFunctions;
    @NotNull
    private static final List<FqName> countFunctions;

    public UseIsNullOrEmpty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseIsNullOrEmpty", Severity.Style, "Use 'isNullOrEmpty()' call instead of 'x == null || x.isEmpty()'", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseIsNullOrEmpty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        KtBinaryExpression ktBinaryExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.OROR)) {
            return;
        }
        KtExpression ktExpression = expression.getLeft();
        KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression left = ktBinaryExpression;
        KtExpression ktExpression2 = expression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression = ktExpression2;
        ktExpression2 = this.nullCheckedExpression(left);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression nullCheckedExpression = ktExpression2;
        KtSimpleNameExpression ktSimpleNameExpression = this.sizeCheckedExpression(right);
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression sizeCheckedExpression = ktSimpleNameExpression;
        if (!Intrinsics.areEqual((Object)nullCheckedExpression.getText(), (Object)sizeCheckedExpression.getText())) {
            return;
        }
        String message = "This '" + expression.getText() + "' can be replaced with 'isNullOrEmpty()' call";
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    /*
     * WARNING - void declaration
     */
    private final KtSimpleNameExpression nullCheckedExpression(KtBinaryExpression $this$nullCheckedExpression) {
        Object object;
        KtExpression ktExpression;
        if (!Intrinsics.areEqual((Object)$this$nullCheckedExpression.getOperationToken(), (Object)KtTokens.EQEQ)) {
            return null;
        }
        Object object2 = this.isNullKeyword($this$nullCheckedExpression.getRight()) ? $this$nullCheckedExpression.getLeft() : (ktExpression = this.isNullKeyword($this$nullCheckedExpression.getLeft()) ? $this$nullCheckedExpression.getRight() : null);
        if (ktExpression == null) {
            object = null;
        } else {
            KtSimpleNameExpression ktSimpleNameExpression;
            void $this$safeAs$iv;
            KtExpression ktExpression2 = ktExpression;
            boolean $i$f$safeAs = false;
            Object v2 = $this$safeAs$iv;
            if (!(v2 instanceof KtSimpleNameExpression)) {
                v2 = null;
            }
            if ((ktSimpleNameExpression = (KtSimpleNameExpression)v2) == null) {
                object = null;
            } else {
                ktExpression2 = ktSimpleNameExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtExpression it = ktExpression2;
                boolean bl3 = false;
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)it, (BindingContext)this.getBindingContext());
                object = (kotlinType == null ? false : KotlinTypeKt.isNullable((KotlinType)kotlinType)) ? ktExpression2 : null;
            }
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression = $this$sizeCheckedExpression;
        return ktExpression instanceof KtDotQualifiedExpression ? this.sizeCheckedExpression((KtDotQualifiedExpression)$this$sizeCheckedExpression) : (ktExpression instanceof KtBinaryExpression ? this.sizeCheckedExpression((KtBinaryExpression)$this$sizeCheckedExpression) : null);
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtDotQualifiedExpression $this$sizeCheckedExpression) {
        Object object;
        KtSimpleNameExpression ktSimpleNameExpression;
        if (!this.isCalling($this$sizeCheckedExpression.getSelectorExpression(), emptyCheckFunctions)) {
            return null;
        }
        KtExpression $this$safeAs$iv = $this$sizeCheckedExpression.getReceiverExpression();
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        if ((ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression) == null) {
            object = null;
        } else {
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            object = this.isCollectionOrArrayOrString(it) ? ktSimpleNameExpression2 : null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedExpression(KtBinaryExpression $this$sizeCheckedExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtExpression ktExpression3;
        KtExpression ktExpression4;
        if (!Intrinsics.areEqual((Object)$this$sizeCheckedExpression.getOperationToken(), (Object)KtTokens.EQEQ)) {
            return null;
        }
        Object object = this.isEmptyString($this$sizeCheckedExpression.getRight()) ? ((ktExpression4 = $this$sizeCheckedExpression.getLeft()) == null ? null : this.sizeCheckedEmptyString(ktExpression4)) : (this.isEmptyString($this$sizeCheckedExpression.getLeft()) ? ((ktExpression3 = $this$sizeCheckedExpression.getRight()) == null ? null : this.sizeCheckedEmptyString(ktExpression3)) : (this.isZero($this$sizeCheckedExpression.getRight()) ? ((ktExpression2 = $this$sizeCheckedExpression.getLeft()) == null ? null : this.sizeCheckedEqualToZero(ktExpression2)) : (this.isZero($this$sizeCheckedExpression.getLeft()) ? ((ktExpression = $this$sizeCheckedExpression.getRight()) == null ? null : this.sizeCheckedEqualToZero(ktExpression)) : null)));
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedEmptyString(KtExpression $this$sizeCheckedEmptyString) {
        Object object;
        KtSimpleNameExpression ktSimpleNameExpression;
        KtExpression $this$safeAs$iv = $this$sizeCheckedEmptyString;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression = $this$safeAs$iv;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        if ((ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression) == null) {
            object = null;
        } else {
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            object = this.isString(it) ? ktSimpleNameExpression2 : null;
        }
        return object;
    }

    private final KtSimpleNameExpression sizeCheckedEqualToZero(KtExpression $this$sizeCheckedEqualToZero) {
        KtSimpleNameExpression ktSimpleNameExpression;
        if (!($this$sizeCheckedEqualToZero instanceof KtDotQualifiedExpression)) {
            return null;
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getReceiverExpression();
        KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return null;
        }
        KtSimpleNameExpression receiver = ktSimpleNameExpression;
        ktExpression = ((KtDotQualifiedExpression)$this$sizeCheckedEqualToZero).getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector = ktExpression;
        if (selector instanceof KtCallExpression ? !this.isCollectionOrArrayOrString(receiver) || !this.isCalling(selector, countFunctions) : (Intrinsics.areEqual((Object)selector.getText(), (Object)"size") ? !this.isCollectionOrArray(receiver) : Intrinsics.areEqual((Object)selector.getText(), (Object)"length") && !this.isString(receiver))) {
            return null;
        }
        return receiver;
    }

    private final boolean isNullKeyword(KtExpression $this$isNullKeyword) {
        KtExpression ktExpression = $this$isNullKeyword;
        return Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)KtTokens.NULL_KEYWORD.getValue());
    }

    private final boolean isZero(KtExpression $this$isZero) {
        KtExpression ktExpression = $this$isZero;
        return Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)"0");
    }

    private final boolean isEmptyString(KtExpression $this$isEmptyString) {
        KtExpression ktExpression = $this$isEmptyString;
        return Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)"\"\"");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        CallableDescriptor callableDescriptor;
        void $this$mapTo$iv$iv;
        KtCallExpression ktCallExpression;
        KtCallExpression ktCallExpression2;
        Object $this$safeAs$iv;
        KtCallExpression ktCallExpression3;
        KtExpression ktExpression = $this$isCalling;
        if (ktExpression == null) {
            ktCallExpression3 = null;
        } else {
            $this$safeAs$iv = ktExpression;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtCallExpression)) {
                ktExpression2 = null;
            }
            ktCallExpression3 = ktCallExpression2 = (KtCallExpression)ktExpression2;
        }
        if (ktCallExpression2 == null) {
            KtCallExpression ktCallExpression4;
            UseIsNullOrEmpty $this$safeAs$iv2 = this;
            boolean $i$f$safeAs = false;
            UseIsNullOrEmpty useIsNullOrEmpty = $this$safeAs$iv2;
            if (!(useIsNullOrEmpty instanceof KtDotQualifiedExpression)) {
                useIsNullOrEmpty = null;
            }
            if (($this$safeAs$iv = (KtDotQualifiedExpression)useIsNullOrEmpty) == null) {
                ktCallExpression4 = null;
            } else {
                $this$safeAs$iv2 = $this$safeAs$iv.getSelectorExpression();
                if ($this$safeAs$iv2 == null) {
                    ktCallExpression4 = null;
                } else {
                    UseIsNullOrEmpty $this$safeAs$iv3 = $this$safeAs$iv2;
                    boolean $i$f$safeAs2 = false;
                    UseIsNullOrEmpty useIsNullOrEmpty2 = $this$safeAs$iv3;
                    if (!(useIsNullOrEmpty2 instanceof KtCallExpression)) {
                        useIsNullOrEmpty2 = null;
                    }
                    ktCallExpression4 = ktExpression = (KtCallExpression)useIsNullOrEmpty2;
                }
            }
            if (ktExpression == null) {
                return false;
            }
            ktCallExpression = ktExpression;
        } else {
            ktCallExpression = ktCallExpression2;
        }
        KtCallExpression callExpression = ktCallExpression;
        Iterable $this$map$iv = fqNames;
        boolean $i$f$map = false;
        $this$safeAs$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.shortName().asString();
            collection.add(string);
        }
        ktCallExpression2 = callExpression.getCalleeExpression();
        return CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)(ktCallExpression2 == null ? null : ktCallExpression2.getText())) && CollectionsKt.contains((Iterable)fqNames, (ktCallExpression2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression), (BindingContext)this.getBindingContext())) == null ? null : ((callableDescriptor = ktCallExpression2.getResultingDescriptor()) == null ? null : DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))));
    }

    private final FqName classFqName(KtSimpleNameExpression $this$classFqName) {
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)$this$classFqName), (BindingContext)this.getBindingContext());
        return kotlinType == null ? null : TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType);
    }

    private final boolean isCollectionOrArrayOrString(KtSimpleNameExpression $this$isCollectionOrArrayOrString) {
        FqName fqName = this.classFqName($this$isCollectionOrArrayOrString);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, (Object)this.classFqName($this$isCollectionOrArrayOrString)) || Intrinsics.areEqual((Object)classFqName, (Object)arrayClass) || Intrinsics.areEqual((Object)classFqName, (Object)stringClass);
    }

    private final boolean isCollectionOrArray(KtSimpleNameExpression $this$isCollectionOrArray) {
        FqName fqName = this.classFqName($this$isCollectionOrArray);
        if (fqName == null) {
            return false;
        }
        FqName classFqName = fqName;
        return CollectionsKt.contains((Iterable)collectionClasses, (Object)this.classFqName($this$isCollectionOrArray)) || Intrinsics.areEqual((Object)classFqName, (Object)arrayClass);
    }

    private final boolean isString(KtSimpleNameExpression $this$isString) {
        return Intrinsics.areEqual((Object)this.classFqName($this$isString), (Object)stringClass);
    }

    public UseIsNullOrEmpty() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String p0;
        Object object;
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Companion = new Companion(null);
        FqName[] fqNameArray = new FqName[]{StandardNames.FqNames.list, StandardNames.FqNames.set, StandardNames.FqNames.collection, StandardNames.FqNames.map, StandardNames.FqNames.mutableList, StandardNames.FqNames.mutableSet, StandardNames.FqNames.mutableCollection, StandardNames.FqNames.mutableMap};
        collectionClasses = CollectionsKt.listOf((Object[])fqNameArray);
        fqNameArray = StandardNames.FqNames.array.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameArray, (String)"array.toSafe()");
        arrayClass = fqNameArray;
        fqNameArray = StandardNames.FqNames.string.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameArray, (String)"string.toSafe()");
        stringClass = fqNameArray;
        Object $this$map$iv = (Object[])collectionClasses;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            FqName fqName = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new FqName(it + ".isEmpty");
            collection.add(object);
        }
        $this$map$iv = new String[]{"kotlin.collections.isEmpty", "kotlin.text.isEmpty"};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            FqName fqName = new FqName(p0);
            object.add(fqName);
        }
        object = (List)destination$iv$iv;
        emptyCheckFunctions = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $this$map$iv = new String[]{"kotlin.collections.count", "kotlin.text.count"};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new FqName(p0);
            collection.add(object);
        }
        countFunctions = (List)var3_3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseIsNullOrEmpty$Companion;", "", "()V", "arrayClass", "Lorg/jetbrains/kotlin/name/FqName;", "collectionClasses", "", "countFunctions", "emptyCheckFunctions", "stringClass", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

