/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.BracesOnWhenStatements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001$B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010 \u001a\u00020!*\u00020\u001bH\u0002J\f\u0010\"\u001a\u00020!*\u00020\u001bH\u0002J\f\u0010#\u001a\u00020!*\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u0012\u0004\b\u0012\u0010\f\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "multiLine", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "getMultiLine$annotations", "()V", "getMultiLine", "()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "multiLine$delegate", "Lkotlin/properties/ReadOnlyProperty;", "singleLine", "getSingleLine$annotations", "getSingleLine", "singleLine$delegate", "policy", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "report", "", "violator", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "validate", "branches", "", "visitWhenExpression", "hasNoBraces", "", "hasUnnecessaryBraces", "isMultiStatement", "BracePolicy", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nBracesOnWhenStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,255:1\n766#2:256\n857#2,2:257\n766#2:259\n857#2,2:260\n766#2:262\n857#2,2:263\n1774#2,4:265\n1774#2,4:269\n1855#2,2:273\n1747#2,2:276\n1749#2:280\n1#3:275\n1247#4,2:278\n*S KotlinDebug\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements\n*L\n183#1:256\n183#1:257,2\n187#1:259\n187#1:260,2\n191#1:262\n191#1:263,2\n195#1:265,4\n196#1:269,4\n204#1:273,2\n224#1:276,2\n224#1:280\n227#1:278,2\n*E\n"})
public final class BracesOnWhenStatements
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty singleLine$delegate;
    @NotNull
    private final ReadOnlyProperty multiLine$delegate;

    public BracesOnWhenStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Braces do not comply with the specified policy", Debt.Companion.getFIVE_MINS());
        this.singleLine$delegate = ConfigPropertyKt.config((Object)"necessary", (Function1)singleLine.2.INSTANCE);
        this.multiLine$delegate = ConfigPropertyKt.config((Object)"consistent", (Function1)multiLine.2.INSTANCE);
    }

    public /* synthetic */ BracesOnWhenStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final BracePolicy getSingleLine() {
        return (BracePolicy)((Object)this.singleLine$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    @Configuration(description="single-line braces policy")
    private static /* synthetic */ void getSingleLine$annotations() {
    }

    private final BracePolicy getMultiLine() {
        return (BracePolicy)((Object)this.multiLine$delegate.getValue((Object)this, $$delegatedProperties[1]));
    }

    @Configuration(description="multi-line braces policy")
    private static /* synthetic */ void getMultiLine$annotations() {
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitWhenExpression(expression);
        List list = expression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        this.validate(list, this.policy(expression));
    }

    private final void validate(List<? extends KtWhenEntry> branches, BracePolicy policy) {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasNoBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 2: {
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isMultiStatement(it) && this.hasUnnecessaryBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 3: {
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasUnnecessaryBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 4: {
                int noBraces;
                int n;
                int n2;
                Iterable $this$count$iv = branches;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl = false;
                        if (!this.hasUnnecessaryBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int braces = n2;
                Iterable $this$count$iv2 = branches;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl = false;
                        if (!this.hasNoBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = noBraces = count$iv;
                }
                if (braces != 0 && noBraces != 0) {
                    list = CollectionsKt.take((Iterable)branches, (int)1);
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List violators = list;
        Iterable $this$forEach$iv = violators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtWhenEntry it = (KtWhenEntry)element$iv;
            boolean bl = false;
            this.report(it, policy);
        }
    }

    private final boolean hasNoBraces(KtWhenEntry $this$hasNoBraces) {
        return !($this$hasNoBraces.getExpression() instanceof KtBlockExpression);
    }

    private final boolean hasUnnecessaryBraces(KtWhenEntry $this$hasUnnecessaryBraces) {
        KtExpression expression = $this$hasUnnecessaryBraces.getExpression();
        if (!(expression instanceof KtBlockExpression)) {
            return false;
        }
        Object object = ((KtBlockExpression)expression).getStatements();
        if (object.isEmpty()) {
            boolean bl = false;
            return false;
        }
        Collection collection = object;
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ifEmpty(...)");
        List statements = (List)collection;
        object = CollectionsKt.singleOrNull((List)statements);
        KtLambdaExpression singleLambda = object instanceof KtLambdaExpression ? (KtLambdaExpression)object : null;
        return singleLambda == null || singleLambda.getFunctionLiteral().getArrow() != null;
    }

    private final boolean isMultiStatement(KtWhenEntry $this$isMultiStatement) {
        KtExpression it = $this$isMultiStatement.getExpression();
        boolean bl = false;
        return it instanceof KtBlockExpression && ((KtBlockExpression)it).getStatements().size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    private final BracePolicy policy(KtWhenExpression expression) {
        boolean bl;
        block6: {
            List list = expression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block5: {
                        void $this$any$iv2;
                        KtWhenEntry branch = (KtWhenEntry)element$iv;
                        boolean bl3 = false;
                        PsiElement psiElement = branch.getArrow();
                        if (psiElement == null) {
                            boolean bl4 = false;
                            String string = "When branch " + branch.getText() + " has no arrow!";
                            throw new IllegalArgumentException(string.toString());
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"requireNotNull(...)");
                        Sequence sequence = PsiUtilsKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)false);
                        boolean $i$f$any2 = false;
                        for (Object element$iv2 : $this$any$iv2) {
                            PsiElement it = (PsiElement)element$iv2;
                            boolean bl5 = false;
                            if (!it.textContains('\n')) continue;
                            bl2 = true;
                            break block5;
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean isMultiLine = bl;
        return isMultiLine ? this.getMultiLine() : this.getSingleLine();
    }

    private final void report(KtWhenEntry violator, BracePolicy policy) {
        PsiElement psiElement;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 4: {
                PsiElement psiElement2 = violator.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
                psiElement = ((KtWhenExpression)psiElement2).getWhenKeyword();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                psiElement = violator.getArrow();
                if (psiElement != null) break;
                boolean bl = false;
                String string = "When branch " + violator.getText() + " has no arrow!";
                throw new IllegalArgumentException(string.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement psiElement3 = psiElement;
        Intrinsics.checkNotNull((Object)psiElement3);
        PsiElement reported = psiElement3;
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)reported, (int)0, (int)2, null), policy.getMessage(), null, null, 24, null));
    }

    public BracesOnWhenStatements() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BracesOnWhenStatements.class, "singleLine", "getSingleLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BracesOnWhenStatements.class, "multiLine", "getMultiLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "", "config", "", "message", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getConfig", "()Ljava/lang/String;", "getMessage", "Always", "Consistent", "Necessary", "Never", "Companion", "detekt-rules-style"})
    public static final class BracePolicy
    extends Enum<BracePolicy> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String config;
        @NotNull
        private final String message;
        public static final /* enum */ BracePolicy Always;
        public static final /* enum */ BracePolicy Consistent;
        public static final /* enum */ BracePolicy Necessary;
        public static final /* enum */ BracePolicy Never;
        private static final /* synthetic */ BracePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BracePolicy(String config, String message) {
            this.config = config;
            this.message = message;
        }

        @NotNull
        public final String getConfig() {
            return this.config;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static BracePolicy[] values() {
            return (BracePolicy[])$VALUES.clone();
        }

        public static BracePolicy valueOf(String value) {
            return Enum.valueOf(BracePolicy.class, value);
        }

        @NotNull
        public static EnumEntries<BracePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            Always = new BracePolicy("always", "Missing braces on this branch, add them.");
            Consistent = new BracePolicy("consistent", "Inconsistent braces, make sure all branches either have or don't have braces.");
            Necessary = new BracePolicy("necessary", "Extra braces exist on this branch, remove them.");
            Never = new BracePolicy("never", "Extra braces exist on this branch, remove them.");
            $VALUES = bracePolicyArray = new BracePolicy[]{BracePolicy.Always, BracePolicy.Consistent, BracePolicy.Necessary, BracePolicy.Never};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion;", "", "()V", "getValue", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "arg", "", "detekt-rules-style"})
        @SourceDebugExtension(value={"SMAP\nBracesOnWhenStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,255:1\n3133#2,11:256\n*S KotlinDebug\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion\n*L\n250#1:256,11\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BracePolicy getValue(@NotNull String arg2) {
                BracePolicy bracePolicy;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg");
                    BracePolicy[] $this$singleOrNull$iv = BracePolicy.values();
                    boolean $i$f$singleOrNull = false;
                    BracePolicy single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        BracePolicy element$iv;
                        BracePolicy it = element$iv = $this$singleOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getConfig(), (Object)arg2)) continue;
                        if (found$iv) {
                            bracePolicy = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    bracePolicy = !found$iv ? null : single$iv;
                }
                if (bracePolicy == null) {
                    throw new IllegalStateException(("Unknown value " + arg2 + ", allowed values are: " + ArraysKt.joinToString$default((Object[])BracePolicy.values(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).toString());
                }
                return bracePolicy;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BracePolicy.values().length];
            try {
                nArray[BracePolicy.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Necessary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Never.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Consistent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

