/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.DoubleNegativeLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0002)*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\f\u0010&\u001a\u00020'*\u00020 H\u0002J\u0012\u0010(\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020 0\nH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R'\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0015\u0012\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "negationTokens", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "negativeFunctionNameParts", "", "", "getNegativeFunctionNameParts$annotations", "()V", "getNegativeFunctionNameParts", "()Ljava/util/Set;", "negativeFunctionNameParts$delegate", "Lkotlin/properties/ReadOnlyProperty;", "negativeFunctions", "Lio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda$NegativeFunction;", "getNegativeFunctions$annotations", "getNegativeFunctions", "()Ljava/util/List;", "negativeFunctions$delegate", "splitCamelCaseRegex", "Lkotlin/text/Regex;", "formatMessage", "forbiddenChildren", "Lorg/jetbrains/kotlin/psi/KtExpression;", "negativeFunction", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isForbiddenNegation", "", "joinInBackTicks", "Companion", "NegativeFunction", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nDoubleNegativeLambda.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleNegativeLambda.kt\nio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,132:1\n288#2,2:133\n1549#2:153\n1620#2,3:154\n1747#2,3:157\n287#3,14:135\n228#3,2:149\n240#3:151\n305#3:152\n*S KotlinDebug\n*F\n+ 1 DoubleNegativeLambda.kt\nio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda\n*L\n76#1:133,2\n97#1:153\n97#1:154,3\n98#1:157,3\n79#1:135,14\n79#1:149,2\n79#1:151\n79#1:152\n*E\n"})
public final class DoubleNegativeLambda
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final Regex splitCamelCaseRegex;
    @NotNull
    private final List<KtSingleValueToken> negationTokens;
    @NotNull
    private final ReadOnlyProperty negativeFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty negativeFunctionNameParts$delegate;
    @NotNull
    public static final String NEGATIVE_FUNCTIONS = "negativeFunctions";
    @NotNull
    public static final String NEGATIVE_FUNCTION_NAME_PARTS = "negativeFunctionNameParts";

    public DoubleNegativeLambda(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DoubleNegativeLambda", Severity.Style, "Double negative from a function name expressed in the negative (like `takeUnless`) with a lambda block that also contains negation. This is more readable when rewritten using a positive form of the function (like `takeIf`).", Debt.Companion.getFIVE_MINS());
        this.splitCamelCaseRegex = new Regex("(?<=[a-z])(?=[A-Z])");
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.EXCL, KtTokens.EXCLEQ, KtTokens.EXCLEQEQEQ, KtTokens.NOT_IN, KtTokens.NOT_IS};
        this.negationTokens = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"takeUnless", (Object)"Use `takeIf` instead."), TuplesKt.to((Object)"none", (Object)"Use `all` instead.")};
        this.negativeFunctions$delegate = ConfigPropertyKt.config((Object)ValuesWithReasonKt.valuesWithReason((Pair[])objectArray), (Function1)negativeFunctions.2.INSTANCE);
        objectArray = new String[]{"not", "non"};
        this.negativeFunctionNameParts$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), (Function1)negativeFunctionNameParts.2.INSTANCE);
    }

    public /* synthetic */ DoubleNegativeLambda(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<NegativeFunction> getNegativeFunctions() {
        return (List)this.negativeFunctions$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Function names expressed in the negative that can form double negatives with their lambda blocks. These are grouped together with a recommendation to use a positive counterpart, or `null` if this is unknown.")
    private static /* synthetic */ void getNegativeFunctions$annotations() {
    }

    private final Set<String> getNegativeFunctionNameParts() {
        return (Set)this.negativeFunctionNameParts$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="Function name parts to look for in the lambda block when deciding if the lambda contains a negative.")
    private static /* synthetic */ void getNegativeFunctionNameParts$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            KtExpression ktExpression = expression.getCalleeExpression();
            String string = ktExpression != null ? ktExpression.getText() : null;
            if (string == null) {
                return;
            }
            String calleeExpression = string;
            Iterable $this$firstOrNull$iv = this.getNegativeFunctions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NegativeFunction it = (NegativeFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)calleeExpression)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        NegativeFunction negativeFunction = v2;
        if (negativeFunction == null) {
            return;
        }
        NegativeFunction negativeFunction2 = negativeFunction;
        List list = expression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambdaArgument = ktLambdaArgument;
        PsiElement $i$f$firstOrNull = (PsiElement)lambdaArgument;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(this){
            final /* synthetic */ DoubleNegativeLambda this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DoubleNegativeLambda.access$isForbiddenNegation(this.this$0, it);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var11_13 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var14_16 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List forbiddenChildren2 = (List)to$iv$iv$iv;
        if (!((Collection)forbiddenChildren2).isEmpty()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.formatMessage(forbiddenChildren2, negativeFunction2), null, null, 24, null));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isForbiddenNegation(KtExpression $this$isForbiddenNegation) {
        KtExpression ktExpression = $this$isForbiddenNegation;
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            String it;
            void $this$mapTo$iv$iv;
            if (!(ktExpression instanceof KtCallExpression)) return false;
            if (Intrinsics.areEqual((Object)((KtCallExpression)$this$isForbiddenNegation).getText(), (Object)"not()")) return true;
            String string = ((KtCallExpression)$this$isForbiddenNegation).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            Regex regex = this.splitCamelCaseRegex;
            int n = 0;
            Iterable $this$map$iv = regex.split(charSequence, n);
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                collection.add(string3);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            object = $this$any$iv.iterator();
            do {
                if (!object.hasNext()) return false;
                Object element$iv = object.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!this.getNegativeFunctionNameParts().contains(it));
            return true;
        }
        boolean bl = this.negationTokens.contains(((KtOperationReferenceExpression)$this$isForbiddenNegation).getOperationSignTokenType());
        return bl;
    }

    private final String formatMessage(List<? extends KtExpression> forbiddenChildren2, NegativeFunction negativeFunction) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatMessage_u24lambda_u243.append("Double negative through using " + this.joinInBackTicks(forbiddenChildren2) + " inside a ");
        $this$formatMessage_u24lambda_u243.append('`' + negativeFunction.getSimpleName() + "` lambda. ");
        if (negativeFunction.getRecommendation() != null) {
            $this$formatMessage_u24lambda_u243.append(negativeFunction.getRecommendation());
        } else {
            $this$formatMessage_u24lambda_u243.append("Rewrite in the positive.");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String joinInBackTicks(List<? extends KtExpression> $this$joinInBackTicks) {
        return CollectionsKt.joinToString$default((Iterable)$this$joinInBackTicks, null, null, null, (int)0, null, (Function1)joinInBackTicks.1.INSTANCE, (int)31, null);
    }

    public DoubleNegativeLambda() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isForbiddenNegation(DoubleNegativeLambda $this, KtExpression $receiver) {
        return $this.isForbiddenNegation($receiver);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DoubleNegativeLambda.class, NEGATIVE_FUNCTIONS, "getNegativeFunctions()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DoubleNegativeLambda.class, NEGATIVE_FUNCTION_NAME_PARTS, "getNegativeFunctionNameParts()Ljava/util/Set;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda$Companion;", "", "()V", "NEGATIVE_FUNCTIONS", "", "NEGATIVE_FUNCTION_NAME_PARTS", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DoubleNegativeLambda$NegativeFunction;", "", "simpleName", "", "recommendation", "(Ljava/lang/String;Ljava/lang/String;)V", "getRecommendation", "()Ljava/lang/String;", "getSimpleName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class NegativeFunction {
        @NotNull
        private final String simpleName;
        @Nullable
        private final String recommendation;

        public NegativeFunction(@NotNull String simpleName, @Nullable String recommendation) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            this.simpleName = simpleName;
            this.recommendation = recommendation;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }

        @Nullable
        public final String getRecommendation() {
            return this.recommendation;
        }

        @NotNull
        public final String component1() {
            return this.simpleName;
        }

        @Nullable
        public final String component2() {
            return this.recommendation;
        }

        @NotNull
        public final NegativeFunction copy(@NotNull String simpleName, @Nullable String recommendation) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            return new NegativeFunction(simpleName, recommendation);
        }

        public static /* synthetic */ NegativeFunction copy$default(NegativeFunction negativeFunction, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = negativeFunction.simpleName;
            }
            if ((n & 2) != 0) {
                string2 = negativeFunction.recommendation;
            }
            return negativeFunction.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "NegativeFunction(simpleName=" + this.simpleName + ", recommendation=" + this.recommendation + ')';
        }

        public int hashCode() {
            int result = this.simpleName.hashCode();
            result = result * 31 + (this.recommendation == null ? 0 : this.recommendation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NegativeFunction)) {
                return false;
            }
            NegativeFunction negativeFunction = (NegativeFunction)other;
            if (!Intrinsics.areEqual((Object)this.simpleName, (Object)negativeFunction.simpleName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.recommendation, (Object)negativeFunction.recommendation);
        }
    }
}

