/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContentKt;
import io.gitlab.arturbosch.detekt.rules.style.MaxLineLengthKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0002J \u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J \u0010,\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J \u0010-\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020/2\u0006\u0010)\u001a\u00020*H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR!\u0010\u0015\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\f\u0012\u0004\b\u0016\u0010\b\u001a\u0004\b\u0017\u0010\nR\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u00020\u001e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\f\u0012\u0004\b\u001f\u0010\b\u001a\u0004\b \u0010!\u00a8\u00064"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeCommentStatements", "", "getExcludeCommentStatements$annotations", "()V", "getExcludeCommentStatements", "()Z", "excludeCommentStatements$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludeImportStatements", "getExcludeImportStatements$annotations", "getExcludeImportStatements", "excludeImportStatements$delegate", "excludePackageStatements", "getExcludePackageStatements$annotations", "getExcludePackageStatements", "excludePackageStatements$delegate", "excludeRawStrings", "getExcludeRawStrings$annotations", "getExcludeRawStrings", "excludeRawStrings$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxLineLength", "", "getMaxLineLength$annotations", "getMaxLineLength", "()I", "maxLineLength$delegate", "containsIgnoredCommentStatement", "line", "", "containsIgnoredImportStatement", "containsIgnoredPackageStatement", "containsIgnoredRawString", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "isIgnoredStatement", "isValidLine", "visit", "", "element", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "visitKtFile", "Companion", "detekt-rules-style"})
public final class MaxLineLength
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxLineLength$delegate;
    @NotNull
    private final ReadOnlyProperty excludePackageStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeImportStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeCommentStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeRawStrings$delegate;
    private static final int DEFAULT_IDEA_LINE_LENGTH = 120;
    @NotNull
    private static final Regex BLANK_OR_QUOTES;

    public MaxLineLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Line detected, which is longer than the defined maximum line length in the code style.", Debt.Companion.getFIVE_MINS());
        this.maxLineLength$delegate = ConfigPropertyKt.config((Object)120);
        this.excludePackageStatements$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeImportStatements$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeCommentStatements$delegate = ConfigPropertyKt.config((Object)false);
        this.excludeRawStrings$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ MaxLineLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxLineLength() {
        return ((Number)this.maxLineLength$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum line length")
    private static /* synthetic */ void getMaxLineLength$annotations() {
    }

    private final boolean getExcludePackageStatements() {
        return (Boolean)this.excludePackageStatements$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if package statements should be ignored")
    private static /* synthetic */ void getExcludePackageStatements$annotations() {
    }

    private final boolean getExcludeImportStatements() {
        return (Boolean)this.excludeImportStatements$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="if import statements should be ignored")
    private static /* synthetic */ void getExcludeImportStatements$annotations() {
    }

    private final boolean getExcludeCommentStatements() {
        return (Boolean)this.excludeCommentStatements$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="if comment statements should be ignored")
    private static /* synthetic */ void getExcludeCommentStatements$annotations() {
    }

    private final boolean getExcludeRawStrings() {
        return (Boolean)this.excludeRawStrings$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="if raw strings should be ignored")
    private static /* synthetic */ void getExcludeRawStrings$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        this.visit(KtFileContentKt.toFileContent(file));
    }

    private final void visit(KtFileContent element) {
        int offset = 0;
        Sequence<String> lines = element.getContent();
        KtFile file = element.getFile();
        for (String line : lines) {
            if (!this.isValidLine(file, offset += line.length(), line)) {
                PsiElement psiElement = MaxLineLength.Companion.findFirstMeaningfulKtElementInParents(file, offset, line);
                if (psiElement == null) {
                    psiElement = (PsiElement)file;
                }
                PsiElement ktElement = psiElement;
                Location location = Location.Companion.from((PsiElement)file, offset - line.length());
                boolean bl = false;
                Location location2 = new Location(location.getSource(), new SourceLocation(location.getSource().getLine(), line.length() + 1), new TextLocation(offset - line.length(), offset), location.getFilePath());
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from(ktElement, location2), this.getIssue().getDescription(), null, null, 24, null));
            }
            ++offset;
        }
    }

    private final boolean isValidLine(KtFile file, int offset, String line) {
        boolean isUrl = StringExtensionsKt.lastArgumentMatchesUrl((String)line);
        boolean isMarkdownOrRefUrl = StringExtensionsKt.lastArgumentMatchesMarkdownUrlSyntax((String)line) || StringExtensionsKt.lastArgumentMatchesKotlinReferenceUrlSyntax((String)line);
        return line.length() <= this.getMaxLineLength() || this.isIgnoredStatement(file, offset, line) || isUrl || isMarkdownOrRefUrl;
    }

    private final boolean isIgnoredStatement(KtFile file, int offset, String line) {
        return this.containsIgnoredPackageStatement(line) || this.containsIgnoredImportStatement(line) || this.containsIgnoredCommentStatement(line) || this.containsIgnoredRawString(file, offset, line);
    }

    private final boolean containsIgnoredRawString(KtFile file, int offset, String line) {
        if (!this.getExcludeRawStrings()) {
            return false;
        }
        PsiElement psiElement = (PsiElement)SequencesKt.lastOrNull(JunkKt.findKtElementInParents(file, offset, line));
        return psiElement != null ? MaxLineLengthKt.access$isInsideRawString(psiElement) : false;
    }

    private final boolean containsIgnoredPackageStatement(String line) {
        if (!this.getExcludePackageStatements()) {
            return false;
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"package ", (boolean)false, (int)2, null);
    }

    private final boolean containsIgnoredImportStatement(String line) {
        if (!this.getExcludeImportStatements()) {
            return false;
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"import ", (boolean)false, (int)2, null);
    }

    private final boolean containsIgnoredCommentStatement(String line) {
        if (!this.getExcludeCommentStatements()) {
            return false;
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"//", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"/*", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"*", (boolean)false, (int)2, null);
    }

    public MaxLineLength() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "maxLineLength", "getMaxLineLength()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludePackageStatements", "getExcludePackageStatements()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludeImportStatements", "getExcludeImportStatements()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludeCommentStatements", "getExcludeCommentStatements()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MaxLineLength.class, "excludeRawStrings", "getExcludeRawStrings()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        BLANK_OR_QUOTES = new Regex("[\\s\"]*");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion;", "", "()V", "BLANK_OR_QUOTES", "Lkotlin/text/Regex;", "DEFAULT_IDEA_LINE_LENGTH", "", "findFirstMeaningfulKtElementInParents", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "line", "", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nMaxLineLength.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxLineLength.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,140:1\n179#2,2:141\n*S KotlinDebug\n*F\n+ 1 MaxLineLength.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion\n*L\n132#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final PsiElement findFirstMeaningfulKtElementInParents(KtFile file, int offset, String line) {
            Object v2;
            block1: {
                void $this$firstOrNull$iv;
                Sequence<PsiElement> sequence = JunkKt.findKtElementInParents(file, offset, line);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    Regex regex = BLANK_OR_QUOTES;
                    String string = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!(!regex.matches((CharSequence)string))) continue;
                    v2 = element$iv;
                    break block1;
                }
                v2 = null;
            }
            return v2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

