/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtLambdaExpressionKt;
import io.gitlab.arturbosch.detekt.rules.style.MultilineLambdaItParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "hasNoLineBreak", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "hasNoStatements", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMultilineLambdaItParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLambdaItParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter\n+ 2 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,119:1\n55#2:120\n1549#3:121\n1620#3,3:122\n243#4:125\n254#4,10:126\n276#4:136\n*S KotlinDebug\n*F\n+ 1 MultilineLambdaItParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter\n*L\n82#1:120\n86#1:121\n86#1:122,3\n117#1:125\n117#1:126,10\n117#1:136\n*E\n"})
public final class MultilineLambdaItParameter
extends Rule {
    @NotNull
    private final Config config;
    @NotNull
    private final Issue issue;

    public MultilineLambdaItParameter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.config = config;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Multiline lambdas should not use `it` as a parameter name.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        ValueParameterDescriptor implicitParameter;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        KtBlockExpression ktBlockExpression = lambdaExpression.getBodyExpression();
        List list = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection $this$ifEmpty$iv = list;
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            return;
        }
        List statements = (List)$this$ifEmpty$iv;
        KtExpression single = (KtExpression)CollectionsKt.singleOrNull((List)statements);
        if (single != null && (this.hasNoLineBreak(single) || this.hasNoStatements(single))) {
            return;
        }
        List list2 = lambdaExpression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List parameterNames = (List)destination$iv$iv;
        if (parameterNames.contains("it")) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), "The parameter name in a multiline lambda should not be an explicit `it`. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
        } else if (parameterNames.isEmpty() && (implicitParameter = KtLambdaExpressionKt.implicitParameter((KtLambdaExpression)lambdaExpression, (BindingContext)this.getBindingContext())) != null && KtLambdaExpressionKt.hasImplicitParameterReference((KtLambdaExpression)lambdaExpression, (ValueParameterDescriptor)implicitParameter, (BindingContext)this.getBindingContext())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), "The implicit `it` should not be used in a multiline lambda. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
        }
    }

    private final boolean hasNoLineBreak(KtExpression $this$hasNoLineBreak) {
        return !$this$hasNoLineBreak.textContains('\n');
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoStatements(KtExpression $this$hasNoStatements) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$hasNoStatements;
        Function1 predicate$iv = hasNoStatements.1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBlockExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }
}

