/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NewLineAtEndOfFile;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules-style"})
public final class NewLineAtEndOfFile
extends Rule {
    @NotNull
    private final Issue issue;

    public NewLineAtEndOfFile(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Checks whether files end with a line separator.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NewLineAtEndOfFile(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String text = file.getText();
        Intrinsics.checkNotNull((Object)text);
        if (((CharSequence)text).length() > 0 && !StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null)) {
            PsiDiagnosticUtils.LineAndColumn coords;
            PsiDiagnosticUtils.LineAndColumn lineAndColumn = coords = KtFilesKt.getLineAndColumnInPsiFile((PsiFile)((PsiFile)file), (TextRange)new TextRange(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)file)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)file))));
            PsiDiagnosticUtils.LineAndColumn lineAndColumn2 = coords;
            SourceLocation sourceLocation = new SourceLocation(lineAndColumn != null ? lineAndColumn.getLine() : 0, lineAndColumn2 != null ? lineAndColumn2.getColumn() : 0);
            TextLocation textLocation = new TextLocation(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)file)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)file)));
            PsiFile psiFile = file.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            Location location = new Location(sourceLocation, textLocation, KtFilesKt.toFilePath((PsiFile)psiFile));
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)file, location), "The file " + file.getName() + " is not ending with a new line.", null, null, 24, null));
        }
    }

    public NewLineAtEndOfFile() {
        this(null, 1, null);
    }
}

